/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.AttributeAssignment;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obligation
extends PolicySchemaObject {
    private static final long serialVersionUID = 1907803486459482543L;
    public static final String PERMIT = "Permit";
    public static final String DENY = "Deny";
    private URI obligationId;
    private boolean isFulfillOnPermit;
    private List<AttributeAssignment> attributeAssignments;

    public Obligation(URI obligationId, boolean isFulfillOnPermit) {
        this(obligationId, isFulfillOnPermit, null);
    }

    public Obligation(URI obligationId, boolean isFulfillOnPermit, List<AttributeAssignment> attributeAssignments) {
        this.obligationId = obligationId;
        this.isFulfillOnPermit = isFulfillOnPermit;
        this.attributeAssignments = attributeAssignments != null ? Collections.unmodifiableList(attributeAssignments) : null;
    }

    public Obligation(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.obligationId = new URI(attrs.getNamedItem("ObligationId").getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        this.isFulfillOnPermit = PERMIT.equals(attrs.getNamedItem("FulfillOn").getNodeValue());
        ArrayList<AttributeAssignment> attributeAssignments = new ArrayList<AttributeAssignment>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("AttributeAssignment")) continue;
            attributeAssignments.add(new AttributeAssignment(registry, node));
        }
        this.attributeAssignments = Collections.unmodifiableList(attributeAssignments);
    }

    @Override
    public String getElementName() {
        return "Obligation";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        ps.print(" ObligationId=\"");
        ps.print(this.obligationId);
        ps.print("\" FulfillOn=\"");
        ps.print(this.isFulfillOnPermit ? PERMIT : DENY);
        ps.print("\"");
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.attributeAssignments != null) {
            Iterator<AttributeAssignment> it = this.attributeAssignments.iterator();
            while (it.hasNext()) {
                it.next().encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Obligation)) {
            return false;
        }
        Obligation o = (Obligation)other;
        return (this.obligationId == o.obligationId || this.obligationId != null && this.obligationId.equals(o.obligationId)) && this.isFulfillOnPermit == o.isFulfillOnPermit && CollectionUtil.equals(this.attributeAssignments, o.attributeAssignments);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.obligationId);
        result = HashCodeUtil.hash((int)result, (boolean)this.isFulfillOnPermit);
        result = HashCodeUtil.hash((int)result, this.attributeAssignments);
        return result;
    }

    public URI getId() {
        return this.obligationId;
    }

    public boolean isFulfillOnPermit() {
        return this.isFulfillOnPermit;
    }

    public List<AttributeAssignment> getAttributeAssignments() {
        return this.attributeAssignments;
    }
}

