/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Obligation;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obligations
extends PolicySchemaObject {
    private static final long serialVersionUID = -4937409216784603791L;
    private List<Obligation> obligations;

    public Obligations(List<Obligation> obligations) {
        this.obligations = obligations != null ? Collections.unmodifiableList(obligations) : null;
    }

    public Obligations(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<Obligation> obligations = new ArrayList<Obligation>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Obligation")) continue;
            obligations.add(new Obligation(registry, node));
        }
        this.obligations = Collections.unmodifiableList(obligations);
    }

    @Override
    public String getElementName() {
        return "Obligations";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.obligations != null) {
            Iterator<Obligation> it = this.obligations.iterator();
            while (it.hasNext()) {
                it.next().encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Obligations)) {
            return false;
        }
        Obligations o = (Obligations)other;
        return CollectionUtil.equals(this.obligations, o.obligations);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.obligations);
        return result;
    }

    public List<Obligation> getObligations() {
        return this.obligations;
    }
}

