/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.SchemaObject;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.AbstractPolicy;
import com.bea.common.security.xacml.policy.CombinerParameters;
import com.bea.common.security.xacml.policy.IdReference;
import com.bea.common.security.xacml.policy.Obligations;
import com.bea.common.security.xacml.policy.Policy;
import com.bea.common.security.xacml.policy.PolicyCombinerParameters;
import com.bea.common.security.xacml.policy.PolicyIdReference;
import com.bea.common.security.xacml.policy.PolicySetCombinerParameters;
import com.bea.common.security.xacml.policy.PolicySetDefaults;
import com.bea.common.security.xacml.policy.PolicySetIdReference;
import com.bea.common.security.xacml.policy.PolicySetMember;
import com.bea.common.security.xacml.policy.Target;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySet
extends AbstractPolicy {
    private static final long serialVersionUID = -6991240254829029111L;
    private List<PolicyCombinerParameters> policyCombinerParameters;
    private List<PolicySetCombinerParameters> policySetCombinerParameters;
    private List<PolicySetMember> policiesPolicySetsAndReferences;
    private PolicySetDefaults defaults;

    public PolicySet(URI id, Target target, URI combiningAlgId, List<PolicySetMember> policiesPolicySetsAndReferences) {
        super(id, target, combiningAlgId);
        this.policiesPolicySetsAndReferences = policiesPolicySetsAndReferences != null ? Collections.unmodifiableList(policiesPolicySetsAndReferences) : null;
    }

    public PolicySet(URI id, Target target, URI combiningAlgId, String description, List<PolicySetMember> policiesPolicySetsAndReferences) {
        super(id, target, combiningAlgId, description);
        this.policiesPolicySetsAndReferences = policiesPolicySetsAndReferences != null ? Collections.unmodifiableList(policiesPolicySetsAndReferences) : null;
    }

    public PolicySet(URI id, Target target, URI combiningAlgId, String description, String version, List<PolicySetMember> policiesPolicySetsAndReferences) {
        super(id, target, combiningAlgId, description, version);
        this.policiesPolicySetsAndReferences = policiesPolicySetsAndReferences != null ? Collections.unmodifiableList(policiesPolicySetsAndReferences) : null;
    }

    public PolicySet(URI id, Target target, URI combiningAlgId, String description, String version, PolicySetDefaults defaults, List<CombinerParameters> combinerParameters, Obligations obligations, List<PolicySetMember> policiesPolicySetsAndReferences) {
        super(id, target, combiningAlgId, description, version, combinerParameters, obligations);
        this.policiesPolicySetsAndReferences = policiesPolicySetsAndReferences != null ? Collections.unmodifiableList(policiesPolicySetsAndReferences) : null;
        this.defaults = defaults;
    }

    public PolicySet(URI id, Target target, URI combiningAlgId, String description, String version, PolicySetDefaults defaults, List<CombinerParameters> combinerParameters, Obligations obligations, List<PolicySetMember> policiesPolicySetsAndReferences, List<PolicyCombinerParameters> policyCombinerParameters, List<PolicySetCombinerParameters> policySetCombinerParameters) {
        super(id, target, combiningAlgId, description, version, combinerParameters, obligations);
        this.policiesPolicySetsAndReferences = policiesPolicySetsAndReferences != null ? Collections.unmodifiableList(policiesPolicySetsAndReferences) : null;
        this.policyCombinerParameters = policyCombinerParameters != null ? Collections.unmodifiableList(policyCombinerParameters) : null;
        this.policySetCombinerParameters = policySetCombinerParameters != null ? Collections.unmodifiableList(policySetCombinerParameters) : null;
        this.defaults = defaults;
    }

    public PolicySet(AttributeRegistry registry, Node root) throws DocumentParseException, URISyntaxException {
        super(registry, root, "PolicySet", "PolicyCombiningAlgId");
        this.policyCombinerParameters = new ArrayList<PolicyCombinerParameters>();
        this.policySetCombinerParameters = new ArrayList<PolicySetCombinerParameters>();
        this.policiesPolicySetsAndReferences = new ArrayList<PolicySetMember>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String cname = this.getLocalName(node);
            if (cname.equals("PolicySetCombinerParameters")) {
                this.policySetCombinerParameters.add(new PolicySetCombinerParameters(registry, node));
                continue;
            }
            if (cname.equals("PolicyCombinerParameters")) {
                this.policyCombinerParameters.add(new PolicyCombinerParameters(registry, node));
                continue;
            }
            if (cname.equals("PolicySet")) {
                this.policiesPolicySetsAndReferences.add(new PolicySet(registry, node));
                continue;
            }
            if (cname.equals("Policy")) {
                this.policiesPolicySetsAndReferences.add(new Policy(registry, node));
                continue;
            }
            if (cname.equals("PolicySetIdReference")) {
                this.policiesPolicySetsAndReferences.add(new PolicySetIdReference(node));
                continue;
            }
            if (cname.equals("PolicyIdReference")) {
                this.policiesPolicySetsAndReferences.add(new PolicyIdReference(node));
                continue;
            }
            if (!cname.equals("PolicySetDefaults")) continue;
            this.defaults = new PolicySetDefaults(node);
        }
        this.policyCombinerParameters = this.policyCombinerParameters.isEmpty() ? null : Collections.unmodifiableList(this.policyCombinerParameters);
        this.policySetCombinerParameters = this.policySetCombinerParameters.isEmpty() ? null : Collections.unmodifiableList(this.policySetCombinerParameters);
        this.policiesPolicySetsAndReferences = this.policiesPolicySetsAndReferences.isEmpty() ? null : Collections.unmodifiableList(this.policiesPolicySetsAndReferences);
    }

    @Override
    protected String getPolicyPrefix() {
        return "PolicySet";
    }

    @Override
    protected String getCombiningName() {
        return "PolicyCombiningAlgId";
    }

    @Override
    public IdReference getReference() {
        return new PolicySetIdReference(this.getId(), this.getVersion());
    }

    @Override
    public String getElementName() {
        return "PolicySet";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        this.encodeDescription(ps);
        if (this.defaults != null) {
            this.defaults.encode(nsMap, ps);
        }
        this.encodeTarget(nsMap, ps);
        this.encodeCombinerParameters(nsMap, ps);
        if (this.policyCombinerParameters != null) {
            for (PolicyCombinerParameters policyCombinerParameters : this.policyCombinerParameters) {
                policyCombinerParameters.encode(nsMap, ps);
            }
        }
        if (this.policySetCombinerParameters != null) {
            for (PolicySetCombinerParameters policySetCombinerParameters : this.policySetCombinerParameters) {
                policySetCombinerParameters.encode(nsMap, ps);
            }
        }
        if (this.policiesPolicySetsAndReferences != null) {
            for (PolicySetMember policySetMember : this.policiesPolicySetsAndReferences) {
                ((SchemaObject)((Object)policySetMember)).encode(nsMap, ps);
            }
        }
        this.encodeObligations(nsMap, ps);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof PolicySet)) {
            return false;
        }
        PolicySet o = (PolicySet)other;
        return CollectionUtil.equals(this.policyCombinerParameters, o.policyCombinerParameters) && CollectionUtil.equals(this.policySetCombinerParameters, o.policySetCombinerParameters) && CollectionUtil.equals(this.policiesPolicySetsAndReferences, o.policiesPolicySetsAndReferences) && (this.defaults == o.defaults || this.defaults != null && this.defaults.equals(o.defaults));
    }

    @Override
    public int internalHashCode() {
        int result = super.internalHashCode();
        result = HashCodeUtil.hash((int)result, this.policyCombinerParameters);
        result = HashCodeUtil.hash((int)result, this.policySetCombinerParameters);
        result = HashCodeUtil.hash((int)result, this.policiesPolicySetsAndReferences);
        result = HashCodeUtil.hash((int)result, (Object)this.defaults);
        return result;
    }

    public PolicySetDefaults getDefaults() {
        return this.defaults;
    }

    public List<PolicyCombinerParameters> getPolicyCombinerParameters() {
        return this.policyCombinerParameters;
    }

    public List<PolicySetCombinerParameters> getPolicySetCombinerParameters() {
        return this.policySetCombinerParameters;
    }

    public List<PolicySetMember> getPoliciesPolicySetsAndReferences() {
        return this.policiesPolicySetsAndReferences;
    }
}

