/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import com.bea.common.security.xacml.policy.Resource;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources
extends PolicySchemaObject {
    private static final long serialVersionUID = -2834648146634007658L;
    private List<Resource> contents;

    public Resources(List<Resource> resources) {
        this.contents = resources != null ? Collections.unmodifiableList(resources) : null;
    }

    public Resources(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        ArrayList<Resource> contents = new ArrayList<Resource>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Resource")) continue;
            contents.add(new Resource(registry, node));
        }
        this.contents = Collections.unmodifiableList(contents);
    }

    @Override
    public String getElementName() {
        return "Resources";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.contents != null) {
            for (Resource m : this.contents) {
                m.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resources)) {
            return false;
        }
        Resources o = (Resources)other;
        return CollectionUtil.equals(this.contents, o.contents);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.contents);
        return result;
    }

    public List<Resource> getResources() {
        return this.contents;
    }
}

