/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.policy.AttributeDesignator;
import java.io.PrintStream;
import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SubjectAttributeDesignator
extends AttributeDesignator {
    private static final long serialVersionUID = 3582840085823353659L;
    private static final String ACCESS_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private URI subjectCategory;

    public SubjectAttributeDesignator(URI attributeId, URI dataType, boolean mustBePresent) {
        this(attributeId, dataType, mustBePresent, (URI)null);
    }

    public SubjectAttributeDesignator(URI attributeId, URI dataType, boolean mustBePresent, URI subjectCategory) {
        super(attributeId, dataType, mustBePresent);
        this.subjectCategory = subjectCategory;
    }

    public SubjectAttributeDesignator(URI attributeId, URI dataType, boolean mustBePresent, String issuer) {
        super(attributeId, dataType, mustBePresent, issuer);
    }

    public SubjectAttributeDesignator(URI attributeId, URI dataType, boolean mustBePresent, String issuer, URI subjectCategory) {
        super(attributeId, dataType, mustBePresent, issuer);
        this.subjectCategory = subjectCategory;
    }

    public SubjectAttributeDesignator(Node root) throws URISyntaxException {
        super(root);
        NamedNodeMap attrs = root.getAttributes();
        Node scNode = attrs.getNamedItem("SubjectCategory");
        try {
            this.subjectCategory = new URI(scNode != null ? scNode.getNodeValue() : ACCESS_SUBJECT);
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
    }

    public void encodeAttributes(PrintStream ps) {
        super.encodeAttributes(ps);
        if (this.subjectCategory != null && !ACCESS_SUBJECT.equals(this.subjectCategory)) {
            ps.print(" SubjectCategory=\"");
            ps.print(this.subjectCategory);
            ps.print("\"");
        }
    }

    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof SubjectAttributeDesignator)) {
            return false;
        }
        SubjectAttributeDesignator o = (SubjectAttributeDesignator)other;
        return this.subjectCategory == o.subjectCategory || this.subjectCategory != null && this.subjectCategory.equals(o.subjectCategory) || this.subjectCategory == null && ACCESS_SUBJECT.equals(o.subjectCategory) || o.subjectCategory == null && ACCESS_SUBJECT.equals(this.subjectCategory);
    }

    public int internalHashCode() {
        int result = super.internalHashCode();
        result = HashCodeUtil.hash((int)result, (Object)(this.subjectCategory != null ? this.subjectCategory : ACCESS_SUBJECT));
        return result;
    }

    public URI getSubjectCategory() {
        return this.subjectCategory;
    }

    protected String getDesignatorType() {
        return "Subject";
    }
}

