/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.AttributeSelector;
import com.bea.common.security.xacml.policy.AttributeValue;
import com.bea.common.security.xacml.policy.Match;
import com.bea.common.security.xacml.policy.SubjectAttributeDesignator;
import java.io.PrintStream;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectMatch
extends Match {
    private static final long serialVersionUID = 2207001521170783568L;
    private SubjectAttributeDesignator designator;

    public SubjectMatch(URI matchId, AttributeValue attributeValue, AttributeSelector selector) {
        super(matchId, attributeValue, selector);
    }

    public SubjectMatch(URI matchId, com.bea.common.security.xacml.attr.AttributeValue attributeValue, AttributeSelector selector) {
        super(matchId, attributeValue, selector);
    }

    public SubjectMatch(URI matchId, AttributeValue attributeValue, SubjectAttributeDesignator designator) {
        super(matchId, attributeValue);
        this.designator = designator;
    }

    public SubjectMatch(URI matchId, com.bea.common.security.xacml.attr.AttributeValue attributeValue, SubjectAttributeDesignator designator) {
        super(matchId, attributeValue);
        this.designator = designator;
    }

    public SubjectMatch(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        super(registry, root);
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("SubjectAttributeDesignator")) continue;
            this.designator = new SubjectAttributeDesignator(node);
        }
    }

    @Override
    public String getElementName() {
        return "SubjectMatch";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        this.encodeLeadElements(nsMap, ps);
        if (this.designator != null) {
            this.designator.encode(nsMap, ps);
        }
        this.encodeTrailingElements(nsMap, ps);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof SubjectMatch)) {
            return false;
        }
        SubjectMatch o = (SubjectMatch)other;
        return this.designator == o.designator || this.designator != null && this.designator.equals(o.designator);
    }

    @Override
    public int internalHashCode() {
        int result = super.internalHashCode();
        result = HashCodeUtil.hash((int)result, (Object)this.designator);
        return result;
    }

    public SubjectAttributeDesignator getDesignator() {
        return this.designator;
    }
}

