/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.policy;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.policy.Actions;
import com.bea.common.security.xacml.policy.Environments;
import com.bea.common.security.xacml.policy.PolicySchemaObject;
import com.bea.common.security.xacml.policy.Resources;
import com.bea.common.security.xacml.policy.Subjects;
import java.io.PrintStream;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target
extends PolicySchemaObject {
    private static final long serialVersionUID = -4513336699249999858L;
    private Subjects subjects;
    private Resources resources;
    private Actions actions;
    private Environments environments;

    public Target(Subjects subjects) {
        this(subjects, null, null, null);
    }

    public Target(Resources resources) {
        this(null, resources, null, null);
    }

    public Target(Actions actions) {
        this(null, null, actions, null);
    }

    public Target(Environments environments) {
        this(null, null, null, environments);
    }

    public Target(Subjects subjects, Resources resources) {
        this(subjects, resources, null, null);
    }

    public Target(Resources resources, Actions actions) {
        this(null, resources, actions, null);
    }

    public Target(Subjects subjects, Resources resources, Actions actions) {
        this(subjects, resources, actions, null);
    }

    public Target(Subjects subjects, Resources resources, Actions actions, Environments environments) {
        this.subjects = subjects;
        this.resources = resources;
        this.actions = actions;
        this.environments = environments;
    }

    public Target(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String cname = this.getLocalName(node);
            if (cname.equals("Subjects")) {
                this.subjects = new Subjects(registry, node);
                continue;
            }
            if (cname.equals("Resources")) {
                this.resources = new Resources(registry, node);
                continue;
            }
            if (cname.equals("Actions")) {
                this.actions = new Actions(registry, node);
                continue;
            }
            if (!cname.equals("Environments")) continue;
            this.environments = new Environments(registry, node);
        }
    }

    @Override
    public String getElementName() {
        return "Target";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.subjects != null) {
            this.subjects.encode(nsMap, ps);
        }
        if (this.resources != null) {
            this.resources.encode(nsMap, ps);
        }
        if (this.actions != null) {
            this.actions.encode(nsMap, ps);
        }
        if (this.environments != null) {
            this.environments.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Target)) {
            return false;
        }
        Target o = (Target)other;
        return (this.subjects == o.subjects || this.subjects != null && this.subjects.equals(o.subjects)) && (this.resources == o.resources || this.resources != null && this.resources.equals(o.resources)) && (this.actions == o.actions || this.actions != null && this.actions.equals(o.actions)) && (this.environments == o.environments || this.environments != null && this.environments.equals(o.environments));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.subjects);
        result = HashCodeUtil.hash((int)result, (Object)this.resources);
        result = HashCodeUtil.hash((int)result, (Object)this.actions);
        result = HashCodeUtil.hash((int)result, (Object)this.environments);
        return result;
    }

    public Subjects getSubjects() {
        return this.subjects;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Actions getActions() {
        return this.actions;
    }

    public Environments getEnvironments() {
        return this.environments;
    }
}

