/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.principal;

import weblogic.security.principal.WLSPrincipal;

public abstract class WLSAbstractPrincipal
implements WLSPrincipal {
    private byte[] signature = null;
    private byte[] salt = String.valueOf(System.currentTimeMillis()).getBytes();
    private String name = null;

    protected WLSAbstractPrincipal() {
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (this == another) {
            return true;
        }
        if (!(another instanceof WLSAbstractPrincipal)) {
            return false;
        }
        WLSAbstractPrincipal anotherPrincipal = (WLSAbstractPrincipal)another;
        if (this.name == null || anotherPrincipal.name == null) {
            return this.name == anotherPrincipal.name;
        }
        if (!this.name.equals(anotherPrincipal.name)) {
            return false;
        }
        byte[] anotherSignature = anotherPrincipal.getSignature();
        if (this.signature == anotherSignature) {
            return true;
        }
        if (this.signature == null || anotherSignature == null) {
            return false;
        }
        if (this.signature.length != anotherSignature.length) {
            return false;
        }
        for (int i = 0; i < this.signature.length; ++i) {
            if (this.signature[i] == anotherSignature[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public byte[] getSignedData() {
        return this.name.getBytes();
    }
}

