/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.service;

import weblogic.security.service.ApplicationResource;
import weblogic.security.service.ResourceBase;
import weblogic.security.spi.Resource;

public final class WebServiceResource
extends ResourceBase {
    private static String[] KEYS = new String[]{"application", "contextPath", "webService", "method", "signature"};
    private static final Resource TOP = new WebServiceResource(null, 0);

    private static String flatten(String[] a) {
        if (a == null) {
            return null;
        }
        return WebServiceResource.appendArrayValue(new StringBuffer(256), a, a.length).toString();
    }

    public WebServiceResource(String application, String contextPath, String webService, String method, String[] signature) {
        this.initialize(application, contextPath, webService, method, signature);
    }

    private WebServiceResource(String[] values, int length) {
        this.init(values, length, 0L);
    }

    public void initialize(String application, String contextPath, String webService, String method, String[] signature) {
        String[] vals = new String[]{application, contextPath, webService, method, WebServiceResource.flatten(signature)};
        this.init(vals, 0L);
    }

    protected void writeResourceString(StringBuffer buf) {
        buf.append("type=").append(this.getType());
        for (int i = 0; i < this.length; ++i) {
            buf.append(", ").append(KEYS[i]).append('=');
            if (i != 4) {
                WebServiceResource.appendValue(buf, this.values[i]);
                continue;
            }
            buf.append(this.values[i]);
        }
    }

    public WebServiceResource() {
    }

    public void initialize(String resourceDefinition) {
    }

    public String getType() {
        return "<webservices>";
    }

    public int getFieldType(String fieldName) {
        if (fieldName.equals("signature")) {
            return 3;
        }
        return 1;
    }

    protected Resource makeParent() {
        switch (this.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new ApplicationResource(this.values[0], TOP);
            }
        }
        return new WebServiceResource(this.values, this.length - 1);
    }

    public String[] getKeys() {
        return KEYS;
    }

    public void reset() {
        this.init(null, 0, 0L);
    }
}

