/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.lang.reflect.InvocationTargetException;
import weblogic.security.utils.Factory;
import weblogic.utils.collections.CircularQueue;

public final class Pool {
    private final Factory factory;
    private final CircularQueue queue;

    public Pool(Factory factory, int size) {
        this.factory = factory;
        this.queue = new CircularQueue(size, size);
    }

    public int getCapacity() {
        return this.queue.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance() throws InvocationTargetException {
        Object o;
        Pool pool = this;
        synchronized (pool) {
            o = this.queue.remove();
        }
        if (o != null) {
            return o;
        }
        return this.newInstance();
    }

    public Object newInstance() throws InvocationTargetException {
        return this.factory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnInstance(Object object) {
        Pool pool = this;
        synchronized (pool) {
            if (this.queue.add(object)) {
                return;
            }
        }
        this.destroyInstance(object);
    }

    public void destroyInstance(Object object) {
        this.factory.destroyInstance(object);
    }

    public synchronized void close() {
        while (!this.queue.isEmpty()) {
            this.destroyInstance(this.queue.remove());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

