/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.ExpressionCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentHashMapExpressionCache<T>
implements ExpressionCache<T> {
    private final ConcurrentMap<String, ConcurrentMap<ExpressionCache.Key, T>> cacheManager = new ConcurrentHashMap<String, ConcurrentMap<ExpressionCache.Key, T>>();

    @Override
    public T get(String cacheName, ExpressionCache.Key key) {
        ConcurrentMap cache = (ConcurrentMap)this.cacheManager.get(cacheName);
        return cache == null ? null : (T)cache.get(key);
    }

    @Override
    public T putIfAbsent(String cacheName, ExpressionCache.Key key, T value) {
        T oldValue;
        ConcurrentMap oldCache;
        ConcurrentMap<ExpressionCache.Key, Object> cache = (ConcurrentHashMap<ExpressionCache.Key, T>)this.cacheManager.get(cacheName);
        if (cache == null && (oldCache = (ConcurrentMap)this.cacheManager.putIfAbsent(cacheName, cache = new ConcurrentHashMap<ExpressionCache.Key, T>())) != null) {
            cache = oldCache;
        }
        if ((oldValue = cache.putIfAbsent(key, value)) != null) {
            return oldValue;
        }
        return value;
    }
}

