/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.TransactionDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public final class Dispute {
    private final Calendar receivedDate;
    private final Calendar replyByDate;
    private final Calendar openedDate;
    private final Calendar wonDate;
    private final String currencyIsoCode;
    private final String id;
    private final Reason reason;
    private final Status status;
    private final Kind kind;
    private final BigDecimal amount;
    private final TransactionDetails transactionDetails;

    public Dispute(NodeWrapper node) {
        this.receivedDate = node.findDate("received-date");
        this.replyByDate = node.findDate("reply-by-date");
        this.openedDate = node.findDate("date-opened");
        this.wonDate = node.findDate("date-won");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.reason = EnumUtils.findByName(Reason.class, node.findString("reason"), Reason.GENERAL);
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        this.kind = EnumUtils.findByName(Kind.class, node.findString("kind"), Kind.UNRECOGNIZED);
        this.amount = node.findBigDecimal("amount");
        this.id = node.findString("id");
        this.transactionDetails = new TransactionDetails(node.findFirst("transaction"));
    }

    public Calendar getReceivedDate() {
        return this.receivedDate;
    }

    public Calendar getReplyByDate() {
        return this.replyByDate;
    }

    public Calendar getOpenedDate() {
        return this.openedDate;
    }

    public Calendar getWonDate() {
        return this.wonDate;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public String getId() {
        return this.id;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public Kind getKind() {
        return this.kind;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CHARGEBACK,
        PRE_ARBITRATION,
        RETRIEVAL,
        UNRECOGNIZED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        CANCELLED_RECURRING_TRANSACTION,
        CREDIT_NOT_PROCESSED,
        DUPLICATE,
        FRAUD,
        GENERAL,
        INVALID_ACCOUNT,
        NOT_RECOGNIZED,
        PRODUCT_NOT_RECEIVED,
        PRODUCT_UNSATISFACTORY,
        TRANSACTION_AMOUNT_DIFFERS,
        RETRIEVAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OPEN,
        LOST,
        WON,
        UNRECOGNIZED;

    }
}

