/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy.dns;

import com.browserup.bup.proxy.dns.AdvancedHostResolver;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.littleshoot.proxy.HostResolver;

public class DelegatingHostResolver
implements HostResolver {
    private volatile AdvancedHostResolver resolver;

    public DelegatingHostResolver(AdvancedHostResolver resolver) {
        this.resolver = resolver;
    }

    public AdvancedHostResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(AdvancedHostResolver resolver) {
        this.resolver = resolver;
    }

    public InetSocketAddress resolve(String host, int port) throws UnknownHostException {
        Collection<InetAddress> resolvedAddresses = this.resolver.resolve(host);
        if (!resolvedAddresses.isEmpty()) {
            InetAddress resolvedAddress = (InetAddress)Iterables.get(resolvedAddresses, (int)0);
            return new InetSocketAddress(resolvedAddress, port);
        }
        throw new UnknownHostException(host);
    }
}

