/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy.dns;

import com.browserup.bup.proxy.dns.NativeResolver;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeCacheManipulatingResolver
extends NativeResolver {
    private static final Logger log = LoggerFactory.getLogger(NativeCacheManipulatingResolver.class);

    @Override
    public void clearDNSCache() {
        try {
            Field positiveCacheField = InetAddress.class.getDeclaredField("addressCache");
            positiveCacheField.setAccessible(true);
            Object positiveCacheInstance = positiveCacheField.get(null);
            Field negativeCacheField = InetAddress.class.getDeclaredField("negativeCache");
            negativeCacheField.setAccessible(true);
            Object negativeCacheInstance = positiveCacheField.get(null);
            Class<?> cacheClass = Class.forName("java.net.InetAddress$Cache");
            Field cacheField = cacheClass.getDeclaredField("cache");
            cacheField.setAccessible(true);
            cacheField.set(positiveCacheInstance, new LinkedHashMap());
            cacheField.set(negativeCacheInstance, new LinkedHashMap());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.warn("Unable to clear native JVM DNS cache", (Throwable)e);
        }
    }

    @Override
    public void setPositiveDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        try {
            Class<?> inetAddressCachePolicyClass = Class.forName("sun.net.InetAddressCachePolicy");
            Field positiveCacheTimeoutSeconds = inetAddressCachePolicyClass.getDeclaredField("cachePolicy");
            positiveCacheTimeoutSeconds.setAccessible(true);
            if (timeout < 0) {
                positiveCacheTimeoutSeconds.setInt(null, -1);
                Security.setProperty("networkaddress.cache.ttl", "-1");
            } else {
                positiveCacheTimeoutSeconds.setInt(null, (int)TimeUnit.SECONDS.convert(timeout, timeUnit));
                Security.setProperty("networkaddress.cache.ttl", Long.toString(TimeUnit.SECONDS.convert(timeout, timeUnit)));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.warn("Unable to modify native JVM DNS cache timeouts", (Throwable)e);
        }
    }

    @Override
    public void setNegativeDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        try {
            Class<?> inetAddressCachePolicyClass = Class.forName("sun.net.InetAddressCachePolicy");
            Field negativeCacheTimeoutSeconds = inetAddressCachePolicyClass.getDeclaredField("negativeCachePolicy");
            negativeCacheTimeoutSeconds.setAccessible(true);
            if (timeout < 0) {
                negativeCacheTimeoutSeconds.setInt(null, -1);
                Security.setProperty("networkaddress.cache.negative.ttl", "-1");
            } else {
                negativeCacheTimeoutSeconds.setInt(null, (int)TimeUnit.SECONDS.convert(timeout, timeUnit));
                Security.setProperty("networkaddress.cache.negative.ttl", Long.toString(TimeUnit.SECONDS.convert(timeout, timeUnit)));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.warn("Unable to modify native JVM DNS cache timeouts", (Throwable)e);
        }
    }
}

