/*
 * Copyright 2011-2012 Brian Matthews
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.btmatthews.utils.monitor;

/**
 * Implemented by objects that write error and information messages to log
 * files.
 *
 * @author <a href="mailto:brian@btmatthews.com">Brian Matthews</a>
 * @since 1.0.0
 */
public interface Logger {

    /**
     * Write an information message to the log file.
     *
     * @param message The information message.
     */
    void logInfo(String message);

    /**
     * Write an error message to the log file.
     *
     * @param message The error message.
     */
    void logError(String message);

    /**
     * Write an error message to the log file.
     *
     * @param message The error message.
     * @param cause   The exception that is associated with the error message.
     */
    void logError(String message, Throwable cause);
}
