/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.OpenidClaimSetBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.AbstractAnnotatedAuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.test.annotations.OpenIdClaims;
import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AliasFor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=OAuth2AuthenticationTokenFactory.class)
public @interface WithOAuth2Login {
    @AliasFor(value="authorities")
    public String[] value() default {};

    @AliasFor(value="value")
    public String[] authorities() default {};

    public OpenIdClaims claims() default @OpenIdClaims;

    public String tokenString() default "machin.truc.chose";

    public String authorizedClientRegistrationId() default "bidule";

    public String nameAttributeKey() default "sub";

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class OAuth2AuthenticationTokenFactory
    extends AbstractAnnotatedAuthenticationBuilder<WithOAuth2Login, OAuth2AuthenticationToken> {
        @Override
        public OAuth2AuthenticationToken authentication(WithOAuth2Login annotation) {
            OpenidClaimSet token = ((OpenidClaimSetBuilder)((Object)super.claims(annotation.claims()).usernameClaim(annotation.nameAttributeKey()))).build();
            Set<GrantedAuthority> authorities = super.authorities(annotation.authorities(), annotation.value());
            DefaultOAuth2User principal = new DefaultOAuth2User(authorities, (Map)token, annotation.nameAttributeKey());
            return new OAuth2AuthenticationToken((OAuth2User)principal, authorities, annotation.authorizedClientRegistrationId());
        }
    }
}

