/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.parameterized;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.TypedArgumentConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@ConvertWith(value=AuthenticationArgumentProcessor.class)
public @interface ParameterizedAuthentication {

    public static class AuthenticationArgumentProcessor
    extends TypedArgumentConverter<Authentication, Authentication> {
        protected AuthenticationArgumentProcessor() {
            super(Authentication.class, Authentication.class);
        }

        protected Authentication convert(Authentication source) {
            SecurityContextHolder.getContext().setAuthentication(source);
            return source;
        }
    }
}

