/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.MetaUtils;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

public class Writers {
    static final String DATE_FORMAT = "DATE_FORMAT";

    private Writers() {
    }

    protected static void writeJsonUtf8String(String s, Writer output) throws IOException {
        JsonWriter.writeJsonUtf8String(s, output);
    }

    public static class AtomicBooleanWriter
    extends PrimitiveValueWriter {
    }

    public static class AtomicIntegerWriter
    extends PrimitiveValueWriter {
    }

    public static class AtomicLongWriter
    extends PrimitiveValueWriter {
    }

    public static class BigDecimalWriter
    extends PrimitiveValueWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output) throws IOException {
            BigDecimal big = (BigDecimal)o;
            output.write(34);
            output.write(big.toPlainString());
            output.write(34);
        }
    }

    public static class BigIntegerWriter
    extends PrimitiveValueWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output) throws IOException {
            BigInteger big = (BigInteger)o;
            output.write(34);
            output.write(big.toString(10));
            output.write(34);
        }
    }

    public static class CalendarWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object obj, boolean showType, Writer output) throws IOException {
            Calendar cal = (Calendar)obj;
            MetaUtils.dateFormat.get().setTimeZone(cal.getTimeZone());
            output.write("\"time\":\"");
            output.write(MetaUtils.dateFormat.get().format(cal.getTime()));
            output.write("\",\"zone\":\"");
            output.write(cal.getTimeZone().getID());
            output.write(34);
        }
    }

    public static class ClassWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        public String extractString(Object o) {
            return ((Class)o).getName();
        }
    }

    public static class DateWriter
    implements JsonWriter.JsonClassWriter {
        public void write(Object obj, boolean showType, Writer output, Map args) throws IOException {
            Date date = (Date)obj;
            Object dateFormat = args.get(Writers.DATE_FORMAT);
            if (dateFormat instanceof String) {
                dateFormat = new SimpleDateFormat((String)dateFormat, Locale.ENGLISH);
                args.put(Writers.DATE_FORMAT, dateFormat);
            }
            if (showType) {
                output.write("\"value\":");
            }
            if (dateFormat instanceof Format) {
                output.write("\"");
                output.write(((Format)dateFormat).format(date));
                output.write("\"");
            } else {
                output.write(Long.toString(((Date)obj).getTime()));
            }
        }

        @Override
        public boolean hasPrimitiveForm() {
            return true;
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, Map args) throws IOException {
            if (args.containsKey(Writers.DATE_FORMAT)) {
                this.write(o, false, output, args);
            } else {
                output.write(Long.toString(((Date)o).getTime()));
            }
        }
    }

    public static class DefaultEnumWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object obj, boolean showType, Writer output, Map<String, Object> args) throws IOException {
            output.write("\"name\":");
            Writers.writeJsonUtf8String(((Enum)obj).name(), output);
            JsonWriter writer = this.getWriter(args);
            writer.writeObject(obj, true, true, Set.of("name", "ordinal"));
        }
    }

    public static class EnumAsPrimitiveWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        protected String getKey() {
            return "name";
        }

        @Override
        public String extractString(Object o) {
            return ((Enum)o).name();
        }
    }

    public static class JsonStringWriter
    extends PrimitiveUtf8StringWriter {
    }

    public static class LocaleWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object obj, boolean showType, Writer output) throws IOException {
            Locale locale = (Locale)obj;
            output.write("\"language\":\"");
            output.write(locale.getLanguage());
            output.write("\",\"country\":\"");
            output.write(locale.getCountry());
            output.write("\",\"variant\":\"");
            output.write(locale.getVariant());
            output.write(34);
        }
    }

    public static class PrimitiveTypeWriter
    implements JsonWriter.JsonClassWriter {
        protected String getKey() {
            return "value";
        }

        @Override
        public void write(Object obj, boolean showType, Writer output) throws IOException {
            if (showType) {
                output.write(34);
                output.write(this.getKey());
                output.write("\":");
            }
            this.writePrimitiveForm(obj, output);
        }

        @Override
        public boolean hasPrimitiveForm() {
            return true;
        }
    }

    public static class PrimitiveUtf8StringWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output) throws IOException {
            Writers.writeJsonUtf8String(this.extractString(o), output);
        }
    }

    public static class PrimitiveValueWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output) throws IOException {
            output.write(this.extractString(o));
        }
    }

    public static class StringBufferWriter
    extends PrimitiveUtf8StringWriter {
    }

    public static class StringBuilderWriter
    extends PrimitiveUtf8StringWriter {
    }

    public static class TimeZoneWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        protected String getKey() {
            return "zone";
        }

        @Override
        public String extractString(Object o) {
            return ((TimeZone)o).getID();
        }
    }

    public static class TimestampWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object o, boolean showType, Writer output) throws IOException {
            Timestamp tstamp = (Timestamp)o;
            output.write("\"time\":\"");
            output.write(Long.toString(tstamp.getTime() / 1000L * 1000L));
            output.write("\",\"nanos\":\"");
            output.write(Integer.toString(tstamp.getNanos()));
            output.write(34);
        }
    }

    public static class URLWriter
    extends PrimitiveUtf8StringWriter {
    }

    public static class UUIDWriter
    implements JsonWriter.JsonClassWriter {
        @Override
        public void write(Object obj, boolean showType, Writer output) throws IOException {
            UUID uuid = (UUID)obj;
            output.write("\"mostSigBits\": ");
            output.write(Long.toString(uuid.getMostSignificantBits()));
            output.write(",\"leastSigBits\":");
            output.write(Long.toString(uuid.getLeastSignificantBits()));
        }

        @Override
        public boolean hasPrimitiveForm() {
            return true;
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output) throws IOException {
            UUID buffer = (UUID)o;
            output.write(34);
            output.write(buffer.toString());
            output.write(34);
        }
    }
}

