/*
 * Decompiled with CFR 0.152.
 */
package com.charleskorn.kaml;

import com.charleskorn.kaml.Location;
import com.charleskorn.kaml.YamlPathSegment;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0006\u0010\u001e\u001a\u00020\u0016J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0013H\u00d6\u0001J\t\u0010%\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/charleskorn/kaml/YamlPath;", "", "segments", "", "Lcom/charleskorn/kaml/YamlPathSegment;", "<init>", "(Ljava/util/List;)V", "", "([Lcom/charleskorn/kaml/YamlPathSegment;)V", "getSegments", "()Ljava/util/List;", "endLocation", "Lcom/charleskorn/kaml/Location;", "getEndLocation", "()Lcom/charleskorn/kaml/Location;", "withError", "location", "withListEntry", "index", "", "withMapElementKey", "key", "", "withMapElementValue", "withAliasReference", "name", "withAliasDefinition", "withMerge", "withSegment", "segment", "toHumanReadableString", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "kaml"})
public final class YamlPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<YamlPathSegment> segments;
    @NotNull
    private final Location endLocation;
    @NotNull
    private static final YamlPath root;

    public YamlPath(@NotNull List<? extends YamlPathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
        if (this.segments.isEmpty()) {
            throw new IllegalArgumentException("Path must contain at least one segment.");
        }
        if (!(CollectionsKt.first(this.segments) instanceof YamlPathSegment.Root) && !(CollectionsKt.first(this.segments) instanceof YamlPathSegment.AliasDefinition)) {
            throw new IllegalArgumentException("First element of path must be root segment or alias definition.");
        }
        if (CollectionsKt.drop((Iterable)this.segments, (int)1).contains(YamlPathSegment.Root.INSTANCE)) {
            throw new IllegalArgumentException("Root segment can only be first element of path.");
        }
        this.endLocation = ((YamlPathSegment)CollectionsKt.last(this.segments)).getLocation();
    }

    @NotNull
    public final List<YamlPathSegment> getSegments() {
        return this.segments;
    }

    public YamlPath(YamlPathSegment ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        this(ArraysKt.toList((Object[])segments));
    }

    @NotNull
    public final Location getEndLocation() {
        return this.endLocation;
    }

    @NotNull
    public final YamlPath withError(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.Error(location));
    }

    @NotNull
    public final YamlPath withListEntry(int index, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.ListEntry(index, location));
    }

    @NotNull
    public final YamlPath withMapElementKey(@NotNull String key, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.MapElementKey(key, location));
    }

    @NotNull
    public final YamlPath withMapElementValue(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.MapElementValue(location));
    }

    @NotNull
    public final YamlPath withAliasReference(@NotNull String name, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.AliasReference(name, location));
    }

    @NotNull
    public final YamlPath withAliasDefinition(@NotNull String name, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.AliasDefinition(name, location));
    }

    @NotNull
    public final YamlPath withMerge(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.Merge(location));
    }

    private final YamlPath withSegment(YamlPathSegment segment) {
        return new YamlPath(CollectionsKt.plus((Collection)this.segments, (Object)segment));
    }

    @NotNull
    public final String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        int nextSegmentIndex = 1;
        while (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments)) {
            StringBuilder stringBuilder;
            int segmentIndex;
            YamlPathSegment segment;
            if ((segment = this.segments.get(segmentIndex = nextSegmentIndex++)) instanceof YamlPathSegment.ListEntry) {
                builder.append('[');
                builder.append(((YamlPathSegment.ListEntry)segment).getIndex());
                stringBuilder = builder.append(']');
                continue;
            }
            if (segment instanceof YamlPathSegment.MapElementKey) {
                if (((CharSequence)builder).length() > 0) {
                    builder.append('.');
                }
                stringBuilder = builder.append(((YamlPathSegment.MapElementKey)segment).getKey());
                continue;
            }
            if (segment instanceof YamlPathSegment.AliasReference) {
                builder.append("->&");
                stringBuilder = builder.append(((YamlPathSegment.AliasReference)segment).getName());
                continue;
            }
            if (segment instanceof YamlPathSegment.Merge) {
                builder.append(">>(merged");
                if (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments) && this.segments.get(nextSegmentIndex) instanceof YamlPathSegment.ListEntry) {
                    builder.append(" entry ");
                    YamlPathSegment yamlPathSegment = this.segments.get(nextSegmentIndex);
                    Intrinsics.checkNotNull((Object)yamlPathSegment, (String)"null cannot be cast to non-null type com.charleskorn.kaml.YamlPathSegment.ListEntry");
                    builder.append(((YamlPathSegment.ListEntry)yamlPathSegment).getIndex());
                    ++nextSegmentIndex;
                }
                if (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments) && this.segments.get(nextSegmentIndex) instanceof YamlPathSegment.AliasReference) {
                    builder.append(" &");
                    YamlPathSegment yamlPathSegment = this.segments.get(nextSegmentIndex);
                    Intrinsics.checkNotNull((Object)yamlPathSegment, (String)"null cannot be cast to non-null type com.charleskorn.kaml.YamlPathSegment.AliasReference");
                    builder.append(((YamlPathSegment.AliasReference)yamlPathSegment).getName());
                    ++nextSegmentIndex;
                }
                stringBuilder = builder.append(")");
                continue;
            }
            if (segment instanceof YamlPathSegment.Root || segment instanceof YamlPathSegment.Error || segment instanceof YamlPathSegment.MapElementValue || segment instanceof YamlPathSegment.AliasDefinition) {
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (((CharSequence)builder).length() > 0) {
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "<root>";
    }

    @NotNull
    public final List<YamlPathSegment> component1() {
        return this.segments;
    }

    @NotNull
    public final YamlPath copy(@NotNull List<? extends YamlPathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        return new YamlPath(segments);
    }

    public static /* synthetic */ YamlPath copy$default(YamlPath yamlPath, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = yamlPath.segments;
        }
        return yamlPath.copy(list);
    }

    @NotNull
    public String toString() {
        return "YamlPath(segments=" + this.segments + ')';
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YamlPath)) {
            return false;
        }
        YamlPath yamlPath = (YamlPath)other;
        return Intrinsics.areEqual(this.segments, yamlPath.segments);
    }

    static {
        YamlPathSegment[] yamlPathSegmentArray = new YamlPathSegment[]{YamlPathSegment.Root.INSTANCE};
        root = new YamlPath(yamlPathSegmentArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/charleskorn/kaml/YamlPath$Companion;", "", "<init>", "()V", "root", "Lcom/charleskorn/kaml/YamlPath;", "getRoot", "()Lcom/charleskorn/kaml/YamlPath;", "forAliasDefinition", "name", "", "location", "Lcom/charleskorn/kaml/Location;", "kaml"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final YamlPath getRoot() {
            return root;
        }

        @NotNull
        public final YamlPath forAliasDefinition(@NotNull String name, @NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            YamlPathSegment[] yamlPathSegmentArray = new YamlPathSegment[]{new YamlPathSegment.AliasDefinition(name, location)};
            return new YamlPath(yamlPathSegmentArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

