/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.LValue;
import com.cloudbees.groovy.cps.LValueBlock;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.CallSiteBlock;
import com.cloudbees.groovy.cps.impl.ContinuationGroup;
import com.cloudbees.groovy.cps.impl.ContinuationPtr;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import com.cloudbees.groovy.cps.sandbox.CallSiteTag;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

abstract class PropertyishBlock
extends LValueBlock
implements CallSiteBlock,
Block {
    private final Collection<CallSiteTag> tags;
    private final Block lhs;
    private final Block property;
    private final SourceLocation loc;
    private final boolean safe;
    private static final long serialVersionUID = 1L;
    static final ContinuationPtr fixLhs = new ContinuationPtr(ContinuationImpl.class, "fixLhs");
    static final ContinuationPtr fixName = new ContinuationPtr(ContinuationImpl.class, "fixName");

    public PropertyishBlock(SourceLocation loc, Block lhs, Block property, boolean safe, Collection<CallSiteTag> tags) {
        this.loc = loc;
        this.lhs = lhs;
        this.property = property;
        this.safe = safe;
        this.tags = tags;
    }

    @Override
    @Nonnull
    public Collection<CallSiteTag> getTags() {
        return this.tags != null ? Collections.unmodifiableCollection(this.tags) : Collections.emptySet();
    }

    @Override
    public Next evalLValue(Env e, Continuation k) {
        return new ContinuationImpl(e, k).then(this.lhs, e, fixLhs);
    }

    protected abstract Object rawGet(Env var1, Object var2, Object var3) throws Throwable;

    protected abstract void rawSet(Env var1, Object var2, Object var3, Object var4) throws Throwable;

    class ContinuationImpl
    extends ContinuationGroup
    implements LValue {
        final Continuation k;
        final Env e;
        Object lhs;
        Object name;
        private static final long serialVersionUID = 1L;

        ContinuationImpl(Env e, Continuation k) {
            this.e = e;
            this.k = k;
        }

        public Next fixLhs(Object lhs) {
            this.lhs = lhs;
            return this.then(PropertyishBlock.this.property, this.e, fixName);
        }

        public Next fixName(Object name) {
            this.name = name;
            return this.k.receive(this);
        }

        @Override
        public Next get(Continuation k) {
            if (PropertyishBlock.this.safe && this.lhs == null) {
                return k.receive(null);
            }
            try {
                Object v = PropertyishBlock.this.rawGet(this.e, this.lhs, this.name);
                return k.receive(v);
            }
            catch (CpsCallableInvocation inv) {
                return inv.invoke(this.e, PropertyishBlock.this.loc, k);
            }
            catch (Throwable t) {
                return this.throwException(this.e, t, PropertyishBlock.this.loc, new ReferenceStackTrace());
            }
        }

        @Override
        public Next set(Object v, Continuation k) {
            try {
                PropertyishBlock.this.rawSet(this.e, this.lhs, this.name, v);
                return k.receive(null);
            }
            catch (CpsCallableInvocation inv) {
                return inv.invoke(this.e, PropertyishBlock.this.loc, k);
            }
            catch (Throwable t) {
                return this.throwException(this.e, t, PropertyishBlock.this.loc, new ReferenceStackTrace());
            }
        }
    }
}

