/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v130.browser.Browser;
import org.openqa.selenium.devtools.v130.browser.model.PermissionType;

public class DefaultClipboard
implements Clipboard {
    private final Driver driver;

    public DefaultClipboard(Driver driver) {
        this.driver = driver;
    }

    @Override
    public Driver driver() {
        return this.driver;
    }

    @Override
    public Clipboard object() {
        return this;
    }

    private boolean grantPermission() {
        Optional<HasDevTools> cdpBrowser = WebdriverUnwrapper.cast(this.driver, HasDevTools.class);
        if (cdpBrowser.isPresent() && WebdriverUnwrapper.instanceOf(this.driver, ChromiumDriver.class)) {
            DevTools devTools = cdpBrowser.get().getDevTools();
            devTools.send(Browser.grantPermissions(List.of(PermissionType.CLIPBOARDREADWRITE, PermissionType.CLIPBOARDSANITIZEDWRITE), Optional.empty(), Optional.empty()));
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        if (this.grantPermission()) {
            return Objects.requireNonNull((String)this.driver.executeJavaScript("return await navigator.clipboard.readText()", new Object[0]));
        }
        try {
            this.assertLocalBrowser();
            return Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException e) {
            throw new IllegalStateException("Can't get clipboard data! " + e.getMessage(), e);
        }
    }

    @Override
    public void setText(String text) {
        if (this.grantPermission()) {
            this.driver.executeJavaScript("await navigator.clipboard.writeText(arguments[0])", text);
        } else {
            this.assertLocalBrowser();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), new StringSelection(text));
        }
    }

    private void assertLocalBrowser() {
        if (this.driver.config().remote() != null) {
            throw new IllegalStateException("Remote driver url detected! Please use remote clipboard.");
        }
    }
}

