/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.WebElementWrapper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class DragAndDropOptions {
    private final DragAndDropTarget target;
    private final DragAndDropMethod method;

    public DragAndDropOptions(DragAndDropTarget target, DragAndDropMethod method) {
        this.target = target;
        this.method = method;
    }

    public static DragAndDropOptions to(String cssSelector) {
        return new DragAndDropOptions(new DragAndDropTarget.CssSelector(cssSelector), DragAndDropMethod.JS);
    }

    public static DragAndDropOptions to(WebElement element) {
        return new DragAndDropOptions(new DragAndDropTarget.Element(element), DragAndDropMethod.JS);
    }

    public DragAndDropOptions usingJS() {
        return new DragAndDropOptions(this.target, DragAndDropMethod.JS);
    }

    public DragAndDropOptions usingSeleniumActions() {
        return new DragAndDropOptions(this.target, DragAndDropMethod.ACTIONS);
    }

    public DragAndDropMethod getMethod() {
        return this.method;
    }

    public SelenideElement getTarget(Driver driver) {
        return this.target.toSelenideElement(driver);
    }

    public String toString() {
        return String.format("target: %s, method: %s", new Object[]{this.target, this.method});
    }

    @FunctionalInterface
    public static interface DragAndDropTarget {
        public SelenideElement toSelenideElement(Driver var1);

        public static class Element
        implements DragAndDropTarget {
            private final WebElement element;

            public Element(WebElement element) {
                this.element = element;
            }

            @Override
            public SelenideElement toSelenideElement(Driver driver) {
                return WebElementWrapper.wrap(driver, this.element);
            }

            public String toString() {
                return this.element.toString();
            }
        }

        public static class CssSelector
        implements DragAndDropTarget {
            private final By cssSelector;

            public CssSelector(String cssSelector) {
                this.cssSelector = By.cssSelector((String)cssSelector);
            }

            @Override
            public SelenideElement toSelenideElement(Driver driver) {
                return ElementFinder.wrap(driver, this.cssSelector);
            }

            public String toString() {
                return this.cssSelector.toString();
            }
        }
    }

    public static enum DragAndDropMethod {
        ACTIONS,
        JS;

    }
}

