/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

abstract class JSStorage {
    private final Driver driver;
    private final String storage;

    JSStorage(Driver driver, String storage) {
        this.driver = driver;
        this.storage = storage;
    }

    public Driver driver() {
        return this.driver;
    }

    public boolean containsItem(String key) {
        return this.getItem(key) != null;
    }

    public @Nullable String getItem(String key) {
        return (String)this.driver.executeJavaScript(this.js("return %s.getItem(arguments[0])"), key);
    }

    public void setItem(String key, String value) {
        SelenideLog log = SelenideLogger.beginStep(this.toString(), "setItem", key, value);
        this.driver.executeJavaScript(this.js("%s.setItem(arguments[0], arguments[1])"), key, value);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
    }

    public void removeItem(String key) {
        SelenideLog log = SelenideLogger.beginStep(this.toString(), "removeItem");
        this.driver.executeJavaScript(this.js("%s.removeItem(arguments[0])"), key);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
    }

    public void clear() {
        SelenideLog log = SelenideLogger.beginStep(this.toString(), "clear");
        this.driver.executeJavaScript(this.js("%s.clear()"), new Object[0]);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
    }

    public int size() {
        return Integer.parseInt(Objects.requireNonNull(this.driver.executeJavaScript(this.js("return %s.length"), new Object[0])).toString());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.storage;
    }

    public Map<String, String> getItems() {
        return Objects.requireNonNull((Map)this.driver.executeJavaScript(this.js("return Object.keys(%1$s).reduce((items, key) => {\n   items[key] = %1$s.getItem(key);\n   return items;\n}, {});"), new Object[0]));
    }

    private String js(String jsCodeTemplate) {
        return String.format(jsCodeTemplate, this.storage);
    }
}

