/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.AttributesMismatch;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Plugins;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class Attributes
extends WebElementsCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    protected final List<String> expectedValues;
    protected final String attribute;

    public Attributes(String attribute, List<String> expectedValues) {
        if (expectedValues.isEmpty()) {
            throw new IllegalArgumentException("No expected values given for attribute " + attribute);
        }
        this.expectedValues = Collections.unmodifiableList(expectedValues);
        this.attribute = attribute;
    }

    @Override
    public CheckResult check(Driver driver, List<WebElement> elements) {
        List<@Nullable String> actualValues = communicator.attributes(driver, elements, this.attribute);
        if (actualValues.size() != this.expectedValues.size()) {
            String message = String.format("List size mismatch (expected: %s, actual: %s)", this.expectedValues.size(), actualValues.size());
            return CheckResult.rejected(message, actualValues);
        }
        for (int i = 0; i < this.expectedValues.size(); ++i) {
            String expectedValue = this.expectedValues.get(i);
            String actualValue = actualValues.get(i);
            if (Objects.equals(actualValue, expectedValue)) continue;
            String message = String.format("Attribute \"%s\" values mismatch (#%s expected: \"%s\", actual: \"%s\")", this.attribute, i, expectedValue, actualValue);
            return CheckResult.rejected(message, actualValues);
        }
        return CheckResult.accepted();
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        List<String> actualAttributeValues = lastCheckResult.getActualValueOrElse(Collections.emptyList());
        if (actualAttributeValues.isEmpty()) {
            throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
        }
        String message = lastCheckResult.getMessageOrElse(() -> String.format("Attribute '%s' values mismatch", this.attribute));
        throw new AttributesMismatch(message, collection, this.expectedValues, actualAttributeValues, this.explanation, timeoutMs, cause);
    }

    @Override
    public String toString() {
        return "Attribute: '" + this.attribute + "' values " + this.expectedValues;
    }
}

