/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.TypeOptions;
import com.codeborne.selenide.commands.Clear;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Objects;
import org.openqa.selenium.WebElement;

public class Type
extends FluentCommand {
    private final Clear clear;

    public Type() {
        this(Plugins.inject(Clear.class));
    }

    protected Type(Clear clear) {
        this.clear = clear;
    }

    @Override
    protected void execute(WebElementSource locator, Object[] args) {
        TypeOptions typeOptions = this.extractOptions(Objects.requireNonNull(args));
        this.clearField(locator, typeOptions);
        WebElement element = this.findElement(locator);
        this.typeIntoField(element, typeOptions);
    }

    protected WebElement findElement(WebElementSource locator) {
        return locator.findAndAssertElementIsEditable();
    }

    protected TypeOptions extractOptions(Object[] args) {
        Object object = args[0];
        if (object instanceof TypeOptions) {
            TypeOptions options = (TypeOptions)object;
            return options;
        }
        return TypeOptions.text((CharSequence)Util.firstOf(args));
    }

    protected void clearField(WebElementSource locator, TypeOptions typeOptions) {
        if (typeOptions.shouldClearFieldBeforeTyping()) {
            if (!typeOptions.textToType().isEmpty()) {
                this.clear.clear(locator.driver(), locator.getWebElement());
            } else {
                this.clear.clearAndTrigger(locator.driver(), locator.getWebElement());
            }
        }
    }

    private void typeIntoField(WebElement element, TypeOptions typeOptions) {
        for (int i = 0; i < typeOptions.textToType().length(); ++i) {
            CharSequence character = typeOptions.textToType().subSequence(i, i + 1);
            element.sendKeys(new CharSequence[]{character});
            Stopwatch.sleepAtLeast(typeOptions.timeDelay().toMillis());
        }
    }
}

