/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.conditions.datetime.DateFormatCondition;
import com.codeborne.selenide.conditions.datetime.TemporalCondition;
import java.time.LocalDate;

class DateEquals
extends TemporalCondition<LocalDate> {
    private final LocalDate expectedDate;

    DateEquals(LocalDate expectedDate, String pattern) {
        this(expectedDate, new DateFormatCondition(pattern));
    }

    DateEquals(LocalDate expectedDate, DateFormatCondition format) {
        super("date value", format);
        this.expectedDate = expectedDate;
    }

    @Override
    protected boolean matches(LocalDate actualDate) {
        return this.expectedDate.isEqual(actualDate);
    }

    @Override
    public String toString() {
        return String.format("%s \"%s\"", this.getName(), this.format(this.expectedDate));
    }
}

