/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

public class CollectionSnapshot
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final List<WebElement> elementsSnapshot;
    private Alias alias = Alias.NONE;

    public CollectionSnapshot(CollectionSource collection) {
        this.originalCollection = collection;
        this.elementsSnapshot = new ArrayList<WebElement>(collection.getElements());
    }

    @Override
    public List<WebElement> getElements() {
        return this.elementsSnapshot;
    }

    @Override
    public WebElement getElement(int index) {
        return this.elementsSnapshot.get(index);
    }

    @Override
    public String getSearchCriteria() {
        return String.format("%s.snapshot(%d elements)", this.originalCollection.description(), this.elementsSnapshot.size());
    }

    public String toString() {
        return this.getSearchCriteria();
    }

    @Override
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

