/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.Lazy;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class FileContent {
    private final String filePath;
    private final Lazy<String> content = Lazy.lazyEvaluated(() -> this.readContent());

    public FileContent(String filePath) {
        this.filePath = filePath;
    }

    public String content() {
        return this.content.get();
    }

    private String readContent() {
        try {
            URL url = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(this.filePath));
            return IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load " + this.filePath + " from classpath", e);
        }
    }
}

