/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import org.openqa.selenium.WebElement;

public class HeadOfCollection
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final int size;
    private Alias alias = Alias.NONE;

    public HeadOfCollection(CollectionSource originalCollection, int size) {
        this.originalCollection = originalCollection;
        this.size = size;
    }

    @Override
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    public List<WebElement> getElements() {
        List<WebElement> source = this.originalCollection.getElements();
        return source.subList(0, Math.min(source.size(), this.size));
    }

    @Override
    public WebElement getElement(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
        return this.originalCollection.getElement(index);
    }

    @Override
    public String getSearchCriteria() {
        return this.originalCollection.description() + ":first(" + this.size + ")";
    }

    public String toString() {
        return this.originalCollection + ":first(" + this.size + ")";
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

