/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.FileContent;
import com.codeborne.selenide.impl.Lazy;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;

public class JavaScript {
    private static final Pattern RE = Pattern.compile("import '(.+?\\.js)'", 32);
    private final FileContent jsSource;
    private final Lazy<String> content = Lazy.lazyEvaluated(() -> this.readContent());

    public JavaScript(String jsFileName) {
        this.jsSource = new FileContent(jsFileName);
    }

    String content() {
        return this.content.get();
    }

    private String readContent() {
        String js = this.jsSource.content();
        Matcher matcher = RE.matcher(js);
        while (matcher.find()) {
            String fileName = matcher.group(1);
            String includedScript = new FileContent(fileName).content();
            js = matcher.replaceFirst(Matcher.quoteReplacement(includedScript));
            matcher = RE.matcher(js);
        }
        return js;
    }

    @CanIgnoreReturnValue
    public <T> @Nullable T execute(SearchContext context, Object ... arguments) {
        return (T)JavaScript.jsExecutor(context).executeScript("return " + this.content(), arguments);
    }

    @CanIgnoreReturnValue
    public <T> @Nullable T execute(Driver driver, Object ... arguments) {
        return this.execute((SearchContext)driver.getWebDriver(), arguments);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @CanIgnoreReturnValue
    public <T> T executeOrFail(Driver driver, Object ... arguments) {
        @Nullable List result = Objects.requireNonNull((List)this.execute(driver, arguments));
        if (result.get(1) != null) {
            throw new IllegalArgumentException((String)result.get(1));
        }
        return (T)Objects.requireNonNull(result.get(0));
    }

    public static JavascriptExecutor jsExecutor(SearchContext context) {
        return JavaScript.asJsExecutor(context).orElseThrow(() -> new IllegalArgumentException("Context is not JS-aware: " + context));
    }

    public static Optional<JavascriptExecutor> asJsExecutor(SearchContext context) {
        Optional<JavascriptExecutor> optional;
        SearchContext unwrappedContext;
        if (context instanceof WrapsDriver) {
            WrapsDriver wrapsDriver = (WrapsDriver)context;
            v0 = wrapsDriver.getWrappedDriver();
        } else {
            v0 = unwrappedContext = context;
        }
        if (unwrappedContext instanceof JavascriptExecutor) {
            JavascriptExecutor jsExecutor = (JavascriptExecutor)unwrappedContext;
            optional = Optional.of(jsExecutor);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public @Nullable Object node(SearchContext context) {
        return context instanceof WebDriver ? null : context;
    }
}

