/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelectorMode;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.FileContent;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class WebElementSelector {
    public static WebElementSelector instance = new WebElementSelector();
    protected final FileContent sizzleSource = new FileContent("sizzle.js");

    public WebElement findElement(Driver driver, @Nullable WebElementSource parent, By selector, int index) {
        return index == 0 ? this.findElement(driver, parent, selector) : this.findElements(driver, parent, selector).get(index);
    }

    public WebElement findElement(Driver driver, @Nullable WebElementSource parent, By selector) {
        WebDriver context = parent == null ? driver.getWebDriver() : parent.getWebElement();
        this.checkThatXPathNotStartingFromSlash((SearchContext)context, selector);
        if (driver.config().selectorMode() == SelectorMode.CSS || !(selector instanceof By.ByCssSelector)) {
            return this.findElement((SearchContext)context, selector);
        }
        List<WebElement> webElements = this.evaluateSizzleSelector(driver, (SearchContext)context, (By.ByCssSelector)selector);
        if (webElements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + selector);
        }
        return webElements.get(0);
    }

    public List<WebElement> findElements(Driver driver, @Nullable WebElementSource parent, By selector) {
        WebDriver context = parent == null ? driver.getWebDriver() : parent.getWebElement();
        this.checkThatXPathNotStartingFromSlash((SearchContext)context, selector);
        if (driver.config().selectorMode() == SelectorMode.CSS || !(selector instanceof By.ByCssSelector)) {
            return this.findElements((SearchContext)context, selector);
        }
        return this.evaluateSizzleSelector(driver, (SearchContext)context, (By.ByCssSelector)selector);
    }

    private WebElement findElement(SearchContext context, By selector) {
        try {
            WebElement webElement;
            if (context instanceof SelenideElement) {
                SelenideElement selenideElement = (SelenideElement)context;
                webElement = selenideElement.toWebElement().findElement(selector);
            } else {
                webElement = context.findElement(selector);
            }
            return webElement;
        }
        catch (JavascriptException e) {
            throw WebElementSelector.unwrapInvalidSelectorException(e);
        }
    }

    private List<WebElement> findElements(SearchContext context, By selector) {
        try {
            List list;
            if (context instanceof SelenideElement) {
                SelenideElement selenideElement = (SelenideElement)context;
                list = selenideElement.toWebElement().findElements(selector);
            } else {
                list = context.findElements(selector);
            }
            return list;
        }
        catch (JavascriptException e) {
            throw WebElementSelector.unwrapInvalidSelectorException(e);
        }
    }

    private static WebDriverException unwrapInvalidSelectorException(JavascriptException e) {
        return e.getMessage().contains("An invalid or illegal selector was specified") || e.getMessage().contains("not a valid XPath expression") ? new InvalidSelectorException(e.getMessage(), e.getCause()) : e;
    }

    protected void checkThatXPathNotStartingFromSlash(SearchContext context, By selector) {
        if (context instanceof WebElement && selector instanceof By.ByXPath && selector.toString().startsWith("By.xpath: /")) {
            throw new IllegalArgumentException("XPath starting from / searches from root");
        }
    }

    protected List<WebElement> evaluateSizzleSelector(Driver driver, SearchContext context, By.ByCssSelector sizzleCssSelector) {
        this.injectSizzleIfNeeded(driver);
        String sizzleSelector = sizzleCssSelector.toString().replace("By.selector: ", "").replace("By.cssSelector: ", "");
        if (context instanceof WebElement) {
            return Objects.requireNonNull((List)driver.executeJavaScript("return Sizzle(arguments[0], arguments[1])", sizzleSelector, context));
        }
        return Objects.requireNonNull((List)driver.executeJavaScript("return Sizzle(arguments[0])", sizzleSelector));
    }

    protected void injectSizzleIfNeeded(Driver driver) {
        if (!this.sizzleLoaded(driver).booleanValue()) {
            this.injectSizzle(driver);
        }
    }

    protected Boolean sizzleLoaded(Driver driver) {
        try {
            return Objects.requireNonNull((Boolean)driver.executeJavaScript("return typeof Sizzle != 'undefined'", new Object[0]));
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    protected synchronized void injectSizzle(Driver driver) {
        driver.executeJavaScript(this.sizzleSource.content(), new Object[0]);
    }
}

