/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ElementFinder;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public abstract class WebElementSource {
    private Alias alias = Alias.NONE;

    public abstract Driver driver();

    public abstract WebElement getWebElement();

    public abstract String getSearchCriteria();

    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }

    public Alias getAlias() {
        return this.alias;
    }

    public String description() {
        return this.alias.getOrElse(this::getSearchCriteria);
    }

    public String toString() {
        return this.description();
    }

    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return ElementFinder.wrap(this.driver(), this, WebElementSource.getSelector(arg), index);
    }

    public List<WebElement> findAll() throws IndexOutOfBoundsException {
        return Collections.singletonList(this.getWebElement());
    }

    public ElementNotFound createElementNotFoundError(WebElementCondition condition, @Nullable Throwable cause) {
        if (cause instanceof UIAssertionError) {
            throw new IllegalArgumentException("Unexpected UIAssertionError as a cause of ElementNotFound: " + cause, cause);
        }
        return new ElementNotFound(this.alias, this.getSearchCriteria(), condition, cause);
    }

    public static By getSelector(Object arg) {
        if (arg instanceof By) {
            By by = (By)arg;
            return by;
        }
        if (arg instanceof String) {
            String cssSelector = (String)arg;
            return By.cssSelector((String)cssSelector);
        }
        throw new IllegalArgumentException("Unsupported selector type: " + arg);
    }

    public void checkCondition(String prefix, WebElementCondition condition, boolean invert) {
        this.checkConditionAndReturnElement(prefix, condition, invert);
    }

    @CanIgnoreReturnValue
    private @Nullable WebElement checkConditionAndReturnElement(String prefix, WebElementCondition condition, boolean invert) {
        WebElementCondition check = invert ? Condition.not(condition) : condition;
        Object lastError = null;
        WebElement element = null;
        CheckResult checkResult = null;
        try {
            element = this.getWebElement();
            checkResult = check.check(this.driver(), element);
            if (checkResult.verdict() == CheckResult.Verdict.ACCEPT) {
                return element;
            }
        }
        catch (AssertionError | IndexOutOfBoundsException | WebDriverException e) {
            lastError = e;
        }
        return this.handleError(prefix, condition, invert, check, (Throwable)lastError, element, checkResult);
    }

    private @Nullable WebElement handleError(String prefix, WebElementCondition condition, boolean invert, WebElementCondition check, @Nullable Throwable lastError, @Nullable WebElement element, @Nullable CheckResult checkResult) {
        if (lastError != null && Cleanup.of.isInvalidSelectorError(lastError)) {
            throw Cleanup.of.wrapInvalidSelectorException(lastError);
        }
        if (lastError instanceof UnhandledAlertException) {
            UnhandledAlertException unhandledAlertException = (UnhandledAlertException)lastError;
            throw unhandledAlertException;
        }
        if (element == null) {
            if (check.missingElementSatisfiesCondition()) {
                return null;
            }
            throw this.createElementNotFoundError(check, lastError);
        }
        if (invert) {
            throw new ElementShouldNot(this.driver(), this.getAlias(), this.getSearchCriteria(), prefix, condition, checkResult, element, lastError);
        }
        throw new ElementShould(this.driver(), this.getAlias(), this.getSearchCriteria(), prefix, condition, checkResult, element, lastError);
    }

    public WebElement findAndAssertElementIsVisible() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", Condition.visible, false));
    }

    public WebElement findAndAssertElementIsInteractable() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", Condition.interactable, false));
    }

    public WebElement findAndAssertElementIsClickable() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", Condition.clickable, false));
    }

    public WebElement findAndAssertElementIsEditable() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", Condition.editable, false));
    }
}

