/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.ArgumentsPrinter;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLog;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenideLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SelenideLogger.class);
    private static final ThreadLocal<@Nullable Map<String, LogEventListener>> listeners = new ThreadLocal();
    private static final Pattern REGEX_UPPER_CASE = Pattern.compile("([A-Z])");

    public static void addListener(String name, LogEventListener listener) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        if (threadListeners == null) {
            threadListeners = new HashMap<String, LogEventListener>();
        }
        threadListeners.put(name, listener);
        listeners.set(threadListeners);
    }

    public static SelenideLog beginStep(String source, String methodName, Object ... args) {
        return SelenideLogger.beginStep(source, SelenideLogger.getReadableSubject(methodName, args));
    }

    public static String getReadableSubject(String methodName, Object ... args) {
        return SelenideLogger.readableMethodName(methodName) + "(" + ArgumentsPrinter.readableArguments(args) + ")";
    }

    static String readableMethodName(String methodName) {
        return REGEX_UPPER_CASE.matcher(methodName).replaceAll(" $1").toLowerCase(Locale.ROOT);
    }

    public static SelenideLog beginStep(String source, String subject) {
        Collection<LogEventListener> threadListeners = SelenideLogger.getEventLoggerListeners();
        SelenideLog log = new SelenideLog(source, subject);
        for (LogEventListener listener : threadListeners) {
            try {
                listener.beforeEvent(log);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to call listener {}", (Object)listener, (Object)e);
            }
        }
        return log;
    }

    public static void commitStep(SelenideLog log, Throwable error) {
        log.setError(error);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.FAIL);
    }

    public static void commitStep(SelenideLog log, LogEvent.EventStatus status) {
        log.setStatus(status);
        Collection<LogEventListener> threadListeners = SelenideLogger.getEventLoggerListeners();
        for (LogEventListener listener : threadListeners) {
            try {
                listener.afterEvent(log);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to call listener {}", (Object)listener, (Object)e);
            }
        }
    }

    public static void run(String source, String subject, Runnable runnable) {
        SelenideLogger.wrap(source, subject, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T get(String source, String subject, Supplier<T> supplier) {
        return Objects.requireNonNull(SelenideLogger.wrap(source, subject, supplier));
    }

    @CanIgnoreReturnValue
    public static <T> @Nullable T step(String source, Supplier<T> supplier) {
        return SelenideLogger.wrap(source, "", supplier);
    }

    public static void step(String source, Runnable runnable) {
        SelenideLogger.wrap(source, "", () -> {
            runnable.run();
            return null;
        });
    }

    @CanIgnoreReturnValue
    private static <T> @Nullable T wrap(String source, String subject, Supplier<@Nullable T> supplier) {
        SelenideLog log = SelenideLogger.beginStep(source, subject);
        try {
            T result = supplier.get();
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return result;
        }
        catch (Error | RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    private static Collection<LogEventListener> getEventLoggerListeners() {
        if (listeners.get() == null) {
            listeners.set(new HashMap());
        }
        return Objects.requireNonNull(listeners.get()).values();
    }

    @CanIgnoreReturnValue
    public static <T extends LogEventListener> @Nullable T removeListener(String name) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        return (T)(threadListeners == null ? null : threadListeners.remove(name));
    }

    static <T extends LogEventListener> @Nullable T getListener(String name) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        return (T)(threadListeners == null ? null : threadListeners.get(name));
    }

    public static void removeAllListeners() {
        listeners.remove();
    }

    public static boolean hasListener(String name) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        return threadListeners != null && threadListeners.containsKey(name);
    }
}

