/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.JavaScript;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByDeepShadow {
    private static final JavaScript jsSource = new JavaScript("query-selector-shadow-dom.js");

    public static By cssSelector(String target) {
        return new ByDeepShadowCss(target);
    }

    public static class ByDeepShadowCss
    extends By
    implements Serializable {
        private final String target;

        ByDeepShadowCss(String target) {
            this.target = target;
        }

        public WebElement findElement(SearchContext context) {
            List<WebElement> found = this.findElements(context);
            if (found.isEmpty()) {
                throw new NoSuchElementException("Cannot locate an element in shadow dom " + this);
            }
            return found.get(0);
        }

        public List<WebElement> findElements(SearchContext context) {
            try {
                return Objects.requireNonNull((List)jsSource.execute(context, this.target));
            }
            catch (JavascriptException e) {
                throw new NoSuchElementException(Cleanup.of.webdriverExceptionMessage(e));
            }
        }

        public String toString() {
            return "By.shadowDeepCss: " + this.target;
        }
    }
}

