/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverFactory
extends AbstractDriverFactory {
    @Override
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        SafariDriverService driverService = this.createDriverService(config);
        SafariOptions capabilities = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        return new SafariDriver((DriverService)driverService, capabilities);
    }

    private SafariDriverService createDriverService(Config config) {
        return (SafariDriverService)this.withLog(config, new SafariDriverService.Builder());
    }

    public SafariOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        SafariOptions options = new SafariOptions();
        if (config.headless()) {
            throw new IllegalArgumentException("headless browser not supported in Safari. Set headless property to false.");
        }
        if (StringUtils.isNotEmpty((CharSequence)config.browserBinary())) {
            throw new IllegalArgumentException("browser binary path not supported in Safari. Reset browserBinary setting.");
        }
        return options.merge((Capabilities)this.createCommonCapabilities(new SafariOptions(), config, browser, proxy));
    }
}

