/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import java.util.logging.Logger;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class Events {
    private static final Logger log = Logger.getLogger(Events.class.getName());
    public static Events events = new Events();

    public void fireChangeEvent(WebElement element) {
        if (WebDriverRunner.supportsJavascript()) {
            this.fireEvent(element, "change");
        } else {
            log.fine("Cannot trigger change event: browser does not support javascript");
        }
    }

    public void fireEvent(WebElement element, String ... event) {
        try {
            String jsCodeToTriggerEvent = "var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}";
            Selenide.executeJavaScript("var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}", element, event);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            // empty catch block
        }
    }
}

