/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.codeborne.selenide.Configuration;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.util.HttpMessageContents;
import net.lightbody.bmp.util.HttpMessageInfo;
import org.apache.commons.io.FileUtils;

public class FileDownloadFilter
implements ResponseFilter {
    private static final Logger log = Logger.getLogger(FileDownloadFilter.class.getName());
    private boolean active;
    private final List<File> downloadedFiles = new ArrayList<File>();
    private final List<Response> responses = new ArrayList<Response>();
    private final Pattern patternContentDisposition = Pattern.compile(".*filename\\*?=\"?([^\";]*)\"?(;charset=.*)?.*", 2);

    public void activate() {
        this.downloadedFiles.clear();
        this.responses.clear();
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (!this.active) {
            return;
        }
        this.responses.add(new Response(messageInfo.getUrl(), response.getStatus().code(), response.getStatus().reasonPhrase(), this.toMap(response.headers()), contents.getContentType(), contents.getTextContents()));
        if (response.getStatus().code() < 200 || response.getStatus().code() >= 300) {
            return;
        }
        String fileName = this.getFileName(response);
        if (fileName == null) {
            return;
        }
        File file = this.prepareTargetFile(fileName);
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])contents.getBinaryContents());
            this.downloadedFiles.add(file);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to save downloaded file to " + file.getAbsolutePath() + " for url " + messageInfo.getUrl(), e);
        }
    }

    private Map<String, String> toMap(HttpHeaders headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry header : headers) {
            map.put((String)header.getKey(), (String)header.getValue());
        }
        return map;
    }

    public List<File> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    protected File prepareTargetFile(String fileName) {
        return new File(Configuration.reportsFolder, fileName);
    }

    String getFileName(HttpResponse response) {
        for (Map.Entry header : response.headers().entries()) {
            String fileName = this.getFileNameFromContentDisposition((String)header.getKey(), (String)header.getValue());
            if (fileName == null) continue;
            return fileName;
        }
        return null;
    }

    protected String getFileNameFromContentDisposition(String headerName, String headerValue) {
        if ("Content-Disposition".equalsIgnoreCase(headerName) && headerValue != null) {
            Matcher regex = this.patternContentDisposition.matcher(headerValue);
            return regex.matches() ? regex.replaceFirst("$1") : null;
        }
        return null;
    }

    public String getResponses() {
        StringBuilder sb = new StringBuilder();
        sb.append("Intercepted ").append(this.responses.size()).append(" responses.");
        for (Response response : this.responses) {
            sb.append("\n  ").append(response).append("\n");
        }
        return sb.toString();
    }

    private static class Response {
        private String url;
        private int code;
        private String reasonPhrase;
        private String contentType;
        private Map<String, String> headers;
        private String content;

        private Response(String url, int code, String reasonPhrase, Map<String, String> headers, String contentType, String content) {
            this.url = url;
            this.code = code;
            this.reasonPhrase = reasonPhrase;
            this.headers = headers;
            this.contentType = contentType;
            this.content = content;
        }

        public String toString() {
            return this.url + " -> " + this.code + " \"" + this.reasonPhrase + "\" " + this.headers + " " + this.contentType + " " + " (" + this.content.length() + " bytes)";
        }
    }
}

