/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.google.common.base.Predicate;

public class Waiter {
    public <T> void wait(T subject, Predicate<T> condition, long timeout, long pollingInterval) {
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start) && !condition.apply(subject)) {
            this.sleep(pollingInterval);
        }
    }

    private boolean isTimeoutExceeded(long timeout, long start) {
        return System.currentTimeMillis() - start > timeout;
    }

    void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

