/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.viper.hlsparserj;

import com.comcast.viper.hlsparserj.AbstractPlaylist;
import com.comcast.viper.hlsparserj.PlaylistVersion;
import com.comcast.viper.hlsparserj.tags.UnparsedTag;
import com.comcast.viper.hlsparserj.tags.master.IFrameStreamInf;
import com.comcast.viper.hlsparserj.tags.master.Media;
import com.comcast.viper.hlsparserj.tags.master.StreamInf;
import java.util.ArrayList;
import java.util.List;

public abstract class MasterPlaylist
extends AbstractPlaylist {
    public MasterPlaylist(PlaylistVersion version, List<UnparsedTag> tags) {
        super(version, tags);
    }

    public List<StreamInf> getVariantStreams() {
        return this.getTagList("EXT-X-STREAM-INF");
    }

    public List<IFrameStreamInf> getIFrameStreams() {
        return this.getTagList("EXT-X-I-FRAME-STREAM-INF");
    }

    public List<Media> getAlternateRenditions() {
        return this.getTagList("EXT-X-MEDIA");
    }

    public void removeVariantStream(StreamInf variantStream) {
        this.tags.remove(variantStream.getTag());
        ((List)this.parsedTagListCache.get("EXT-X-STREAM-INF")).remove(variantStream);
    }

    public void keepVariantStreamClosestToBitrate(int bitrate) {
        StreamInf variantStreamToKeep = this.variantStreamClosestToBitrate(bitrate);
        List<StreamInf> variantStreams = this.getVariantStreams();
        ArrayList<StreamInf> streamsToRemove = new ArrayList<StreamInf>();
        for (int i = 0; i < variantStreams.size(); ++i) {
            StreamInf variantStream = variantStreams.get(i);
            if (variantStream.equals(variantStreamToKeep)) continue;
            streamsToRemove.add(variantStream);
        }
        for (StreamInf stream : streamsToRemove) {
            this.removeVariantStream(stream);
        }
    }

    public StreamInf variantStreamClosestToBitrate(int bitrate) {
        int closestBitrate = Integer.MAX_VALUE;
        StreamInf closestVariant = null;
        for (StreamInf variant : this.getVariantStreams()) {
            int bitrateDelta = Math.abs(variant.getBandwidth() - bitrate);
            if (bitrateDelta >= closestBitrate) continue;
            closestBitrate = bitrateDelta;
            closestVariant = variant;
        }
        return closestVariant;
    }

    @Override
    public boolean isMasterPlaylist() {
        return true;
    }
}

