/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.viper.hlsparserj;

import com.comcast.viper.hlsparserj.AbstractPlaylist;
import com.comcast.viper.hlsparserj.PlaylistParser;
import com.comcast.viper.hlsparserj.PlaylistVersion;
import com.comcast.viper.hlsparserj.v12.MasterPlaylistV12;
import com.comcast.viper.hlsparserj.v12.MediaPlaylistV12;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class PlaylistFactory {
    public static AbstractPlaylist parsePlaylist(PlaylistVersion playlistVersion, InputStream playlistStream) throws IOException {
        PlaylistParser parser = new PlaylistParser();
        parser.parse(playlistStream);
        return PlaylistFactory.getVersionSpecificPlaylist(parser, playlistVersion);
    }

    public static AbstractPlaylist parsePlaylist(PlaylistVersion playlistVersion, String playlistString) {
        PlaylistParser parser = new PlaylistParser();
        parser.parse(playlistString);
        return PlaylistFactory.getVersionSpecificPlaylist(parser, playlistVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractPlaylist parsePlaylist(PlaylistVersion playlistVersion, URL playlistURL, int connectTimeout, int requestTimeout, int socketTimeout) throws IOException {
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(connectTimeout);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(requestTimeout);
        requestBuilder = requestBuilder.setSocketTimeout(socketTimeout);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        PlaylistParser parser = new PlaylistParser();
        try (CloseableHttpClient httpClient = builder.build();){
            InputStream playlistStream = PlaylistFactory.getPlaylistInputStream(httpClient, playlistURL);
            parser.parse(playlistStream);
        }
        return PlaylistFactory.getVersionSpecificPlaylist(parser, playlistVersion);
    }

    private static AbstractPlaylist getVersionSpecificPlaylist(PlaylistParser parser, PlaylistVersion playlistVersion) {
        AbstractPlaylist playlist = null;
        switch (playlistVersion) {
            default: 
        }
        playlist = parser.isMasterPlaylist() ? new MasterPlaylistV12(parser.getTags()) : new MediaPlaylistV12(parser.getTags());
        return playlist;
    }

    private static InputStream getPlaylistInputStream(CloseableHttpClient httpClient, URL url) throws IOException {
        HttpGet get = new HttpGet(url.toString());
        CloseableHttpResponse response = null;
        response = httpClient.execute((HttpUriRequest)get);
        if (response == null) {
            throw new IOException("Request returned a null response");
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            response.close();
            throw new IOException("Request returned a status code of " + response.getStatusLine().getStatusCode());
        }
        return response.getEntity().getContent();
    }

    static {
        try {
            Class.forName("com.comcast.viper.hlsparserj.tags.TagNames");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

