/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.viper.hlsparserj;

import com.comcast.viper.hlsparserj.tags.UnparsedTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PlaylistParser {
    private InputStream playlistStream;
    private final List<UnparsedTag> tags = new ArrayList<UnparsedTag>();
    private static final String TAGPATTERN = "^#EXT.*";
    private static final String URIPATTERN = "^[^#].*";
    private boolean isMasterPlaylist = false;

    public void parse(String playlist) {
        this.parseString(playlist);
    }

    public void parse(InputStream inputStream) throws IOException {
        this.playlistStream = inputStream;
        this.parseInputStream();
    }

    public boolean isMasterPlaylist() {
        return this.isMasterPlaylist;
    }

    public List<UnparsedTag> getTags() {
        return this.tags;
    }

    private void parseString(String playlist) {
        StringTokenizer tokenizer = new StringTokenizer(playlist, "\n");
        UnparsedTag lastTag = null;
        while (tokenizer.hasMoreElements()) {
            String line = tokenizer.nextToken();
            lastTag = this.processLine(line, lastTag);
        }
    }

    private void parseInputStream() throws IOException {
        String line;
        InputStreamReader isReader = new InputStreamReader(this.playlistStream);
        BufferedReader bufReader = new BufferedReader(isReader);
        UnparsedTag lastTag = null;
        while ((line = bufReader.readLine()) != null) {
            lastTag = this.processLine(line, lastTag);
        }
    }

    private UnparsedTag processLine(String line, UnparsedTag lastTag) {
        if (line.matches(TAGPATTERN)) {
            UnparsedTag newUnparsedTag = new UnparsedTag(line);
            this.tags.add(newUnparsedTag);
            if (newUnparsedTag.getTagName().equals("EXT-X-STREAM-INF")) {
                this.isMasterPlaylist = true;
            }
            return newUnparsedTag;
        }
        if (line.matches(URIPATTERN) && lastTag != null) {
            lastTag.setURI(line);
            return lastTag;
        }
        return lastTag;
    }
}

