/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.MavenGitCodeFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.logging.Log;

public class TemporaryFile
implements Closeable {
    private final Log log;
    private final Path file;

    private TemporaryFile(Log log, String virtualName) {
        this.log = log;
        try {
            this.file = Files.createTempFile(null, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
        log.debug((CharSequence)("Temporary file virtually named '" + virtualName + "' is viewable at '" + this.file + "'"));
    }

    public static TemporaryFile create(Log log, String virtualName) {
        return new TemporaryFile(log, virtualName);
    }

    public OutputStream newOutputStream() throws IOException {
        return Files.newOutputStream(this.file, new OpenOption[0]);
    }

    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    public long size() throws IOException {
        return Files.size(this.file);
    }

    @Override
    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            return;
        }
        Files.delete(this.file);
    }
}

