/*
 * Copyright (c) 2016 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;

import java.util.List;

public interface Locator {

    /**
     * Given with the environment and node information, the implementation locates the right set of nodes and
     * dispatches the request into them.
     *
     * @param request the request to dispatch.
     * @param nodes the current list of active nodes.
     * @param config the current cluster configuration.
     * @param env the core environment.
     * @param responseBuffer the response buffer for potential redistribution.
     */
    void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env,
                RingBuffer<ResponseEvent> responseBuffer);
}
