/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.flush.FlushConsolidationHandler;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.io.netty.TrafficCaptureHandler;
import com.couchbase.client.core.io.netty.kv.ErrorMapLoadingHandler;
import com.couchbase.client.core.io.netty.kv.FeatureNegotiatingHandler;
import com.couchbase.client.core.io.netty.kv.KeyValueMessageHandler;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocolDecodeHandler;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocolVerificationHandler;
import com.couchbase.client.core.io.netty.kv.SelectBucketHandler;
import com.couchbase.client.core.io.netty.kv.ServerFeature;
import com.couchbase.client.core.io.netty.kv.ServerPushHandler;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public class KeyValueEndpoint
extends BaseEndpoint {
    private final Optional<String> bucketname;
    private final Authenticator authenticator;
    private static final int FLUSH_CONSOLIDATION_LIMIT = Integer.parseInt(System.getProperty("com.couchbase.experimental.flushConsolidationLimit", Integer.toString(256)));

    public KeyValueEndpoint(ServiceContext ctx, String hostname, int port, Optional<String> bucketname, Authenticator authenticator) {
        super(hostname, port, ctx.environment().ioEnvironment().kvEventLoopGroup().get(), ctx, ctx.environment().ioConfig().kvCircuitBreakerConfig(), ServiceType.KV, true);
        this.authenticator = authenticator;
        this.bucketname = bucketname;
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new KeyValuePipelineInitializer(this.context(), this.bucketname, this.authenticator);
    }

    public static class KeyValuePipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext ctx;
        private final Optional<String> bucketname;
        private final Authenticator authenticator;

        public KeyValuePipelineInitializer(EndpointContext ctx, Optional<String> bucketname, Authenticator authenticator) {
            this.ctx = ctx;
            this.authenticator = authenticator;
            this.bucketname = bucketname;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            if (FLUSH_CONSOLIDATION_LIMIT > 0) {
                pipeline.addLast(new FlushConsolidationHandler(FLUSH_CONSOLIDATION_LIMIT, true));
            }
            if (pipeline.get(TrafficCaptureHandler.class) != null) {
                pipeline.addBefore(TrafficCaptureHandler.class.getName(), MemcacheProtocolDecodeHandler.class.getName(), new MemcacheProtocolDecodeHandler());
            } else {
                pipeline.addLast(MemcacheProtocolDecodeHandler.class.getName(), (ChannelHandler)new MemcacheProtocolDecodeHandler());
            }
            pipeline.addAfter(MemcacheProtocolDecodeHandler.class.getName(), MemcacheProtocolVerificationHandler.class.getName(), new MemcacheProtocolVerificationHandler(this.ctx));
            pipeline.addLast(new ServerPushHandler(this.ctx));
            pipeline.addLast(new FeatureNegotiatingHandler(this.ctx, this.serverFeatures()));
            pipeline.addLast(new ErrorMapLoadingHandler(this.ctx));
            this.authenticator.authKeyValueConnection(this.ctx, pipeline);
            this.bucketname.ifPresent(s -> pipeline.addLast(new SelectBucketHandler(this.ctx, (String)s)));
            pipeline.addLast(new KeyValueMessageHandler(endpoint, this.ctx, this.bucketname));
        }

        private Set<ServerFeature> serverFeatures() {
            boolean reportUnitUsageEnabled;
            boolean createAsDeletedEnabled;
            boolean vattrEnabled;
            boolean unorderedExecutionEnabled;
            EnumSet<ServerFeature[]> features = EnumSet.of(ServerFeature.SELECT_BUCKET, new ServerFeature[]{ServerFeature.XATTR, ServerFeature.XERROR, ServerFeature.ALT_REQUEST, ServerFeature.SYNC_REPLICATION, ServerFeature.COLLECTIONS, ServerFeature.TRACING, ServerFeature.PRESERVE_TTL, ServerFeature.JSON, ServerFeature.SUBDOC_READ_REPLICA, ServerFeature.GET_CLUSTER_CONFIG_WITH_KNOWN_VERSION, ServerFeature.DUPLEX, ServerFeature.DEDUPE_NOT_MY_VBUCKET_CLUSTERMAP, ServerFeature.CLUSTERMAP_CHANGE_NOTIFICATION_BRIEF, ServerFeature.SUBDOC_BINARY_XATTR});
            if (this.ctx.environment().ioConfig().mutationTokensEnabled()) {
                features.add((ServerFeature[])ServerFeature.MUTATION_SEQNO);
            }
            if (this.ctx.environment().compressionConfig().enabled()) {
                features.add((ServerFeature[])ServerFeature.SNAPPY);
                features.add((ServerFeature[])ServerFeature.SNAPPY_EVERYWHERE);
            }
            if (unorderedExecutionEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.unorderedExecutionEnabled", "true"))) {
                features.add((ServerFeature[])ServerFeature.UNORDERED_EXECUTION);
            }
            if (vattrEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.vattrEnabled", "true"))) {
                features.add((ServerFeature[])ServerFeature.VATTR);
            }
            if (createAsDeletedEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.createAsDeletedEnabled", "true"))) {
                features.add((ServerFeature[])ServerFeature.CREATE_AS_DELETED);
            }
            if (reportUnitUsageEnabled = Boolean.parseBoolean(System.getProperty("com.couchbase.reportUnitUsageEnabled", "true"))) {
                features.add((ServerFeature[])ServerFeature.REPORT_UNIT_USAGE);
            }
            return features;
        }
    }
}

