/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.grpc.CallCredentials;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.env.UsernameAndPassword;
import com.couchbase.client.core.io.netty.kv.SaslAuthenticationHandler;
import com.couchbase.client.core.io.netty.kv.SaslListMechanismsHandler;
import com.couchbase.client.core.io.netty.kv.sasl.SaslHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

public class PasswordAuthenticator
implements Authenticator {
    private static final Set<SaslMechanism> DEFAULT_SASL_MECHANISMS = EnumSet.of(SaslMechanism.SCRAM_SHA512, SaslMechanism.SCRAM_SHA256, SaslMechanism.SCRAM_SHA1);
    private final Supplier<UsernameAndPassword> usernameAndPassword;
    private final Set<SaslMechanism> allowedSaslMechanisms;
    @Nullable
    private final String cachedHttpAuthHeader;

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String username, String password) {
        return new Builder(username, password);
    }

    public static Builder builder(Supplier<UsernameAndPassword> supplier) {
        return new Builder(supplier);
    }

    public static PasswordAuthenticator create(String username, String password) {
        return PasswordAuthenticator.builder(username, password).build();
    }

    public static PasswordAuthenticator ldapCompatible(String username, String password) {
        return PasswordAuthenticator.builder(username, password).onlyEnablePlainSaslMechanism().build();
    }

    private PasswordAuthenticator(Builder builder) {
        EnumSet<SaslMechanism> tempMechanisms = EnumSet.noneOf(SaslMechanism.class);
        tempMechanisms.addAll(builder.allowedSaslMechanisms);
        this.allowedSaslMechanisms = Collections.unmodifiableSet(tempMechanisms);
        this.usernameAndPassword = builder.resolveUsernameAndPasswordSupplier();
        this.cachedHttpAuthHeader = builder.dynamicCredentials ? null : PasswordAuthenticator.encodeAuthHttpHeader(this.usernameAndPassword.get());
    }

    String getAuthHeaderValue() {
        return this.cachedHttpAuthHeader != null ? this.cachedHttpAuthHeader : PasswordAuthenticator.encodeAuthHttpHeader(this.usernameAndPassword.get());
    }

    private static String encodeAuthHttpHeader(UsernameAndPassword credentials) {
        byte[] encodeMe = (credentials.username() + ":" + credentials.password()).getBytes(StandardCharsets.UTF_8);
        String encoded = Base64.getEncoder().encodeToString(encodeMe);
        return "Basic " + encoded;
    }

    @Override
    public void authKeyValueConnection(EndpointContext ctx, ChannelPipeline pipeline) {
        boolean tls = ctx.environment().securityConfig().tlsEnabled();
        boolean forceSaslPlain = tls && SaslHelper.platformHasSaslPlain();
        UsernameAndPassword credentials = this.usernameAndPassword.get();
        pipeline.addLast(new SaslListMechanismsHandler(ctx));
        pipeline.addLast(new SaslAuthenticationHandler(ctx, credentials.username(), credentials.password(), forceSaslPlain ? EnumSet.of(SaslMechanism.PLAIN) : this.allowedSaslMechanisms));
    }

    @Override
    public void authHttpRequest(ServiceType serviceType, HttpRequest request) {
        request.headers().add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this.getAuthHeaderValue());
    }

    @Override
    public CallCredentials protostellarCallCredentials() {
        return new CallCredentials(){

            @Override
            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
                executor.execute(() -> {
                    try {
                        Metadata headers = new Metadata();
                        headers.put(Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER), PasswordAuthenticator.this.getAuthHeaderValue());
                        applier.apply(headers);
                    }
                    catch (Throwable e) {
                        applier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                });
            }

            @Override
            public void thisUsesUnstableApi() {
            }
        };
    }

    static /* synthetic */ Set access$500() {
        return DEFAULT_SASL_MECHANISMS;
    }

    public static class Builder {
        private Supplier<String> username;
        private Supplier<String> password;
        private Set<SaslMechanism> allowedSaslMechanisms = PasswordAuthenticator.access$500();
        private Supplier<Boolean> platformHasSaslPlain = SaslHelper::platformHasSaslPlain;
        private Supplier<UsernameAndPassword> usernameAndPassword;
        private boolean dynamicCredentials;

        private Builder(Supplier<UsernameAndPassword> usernameAndPassword) {
            this.usernameAndPassword = Objects.requireNonNull(usernameAndPassword);
            this.dynamicCredentials = true;
        }

        private Builder(String username, String password) {
            UsernameAndPassword cached = new UsernameAndPassword(username, password);
            this.usernameAndPassword = () -> cached;
            this.dynamicCredentials = false;
        }

        @Deprecated
        public Builder() {
        }

        @Deprecated
        public Builder username(String username) {
            this.requireDeprecatedConstructor();
            Validators.notNullOrEmpty(username, "Username");
            this.username = () -> username;
            return this;
        }

        @Deprecated
        public Builder username(Supplier<String> username) {
            this.requireDeprecatedConstructor();
            Validators.notNull(username, "Username");
            this.username = username;
            this.dynamicCredentials = true;
            return this;
        }

        @Deprecated
        public Builder password(String password) {
            this.requireDeprecatedConstructor();
            Validators.notNullOrEmpty(password, "Password");
            this.password = () -> password;
            return this;
        }

        @Deprecated
        public Builder password(Supplier<String> password) {
            this.requireDeprecatedConstructor();
            Validators.notNull(password, "Password");
            this.password = password;
            this.dynamicCredentials = true;
            return this;
        }

        public Builder allowedSaslMechanisms(Set<SaslMechanism> allowedSaslMechanisms) {
            Validators.notNullOrEmpty(allowedSaslMechanisms, "AllowedSaslMechanisms");
            if (allowedSaslMechanisms.equals(CbCollections.setOf(SaslMechanism.PLAIN)) && !this.platformHasSaslPlain.get().booleanValue()) {
                throw new RuntimeException("This JVM is running in a restricted mode that prevents using SASL PLAIN for authentication.");
            }
            this.allowedSaslMechanisms = CbCollections.setCopyOf(allowedSaslMechanisms);
            return this;
        }

        public Builder enablePlainSaslMechanism() {
            return this.allowedSaslMechanisms(EnumSet.allOf(SaslMechanism.class));
        }

        public Builder onlyEnablePlainSaslMechanism() {
            return this.allowedSaslMechanisms(EnumSet.of(SaslMechanism.PLAIN));
        }

        @Stability.Internal
        Builder setPlatformHasSaslPlain(Supplier<Boolean> saslPlainAvailable) {
            this.platformHasSaslPlain = Objects.requireNonNull(saslPlainAvailable);
            return this;
        }

        public PasswordAuthenticator build() {
            return new PasswordAuthenticator(this);
        }

        private void requireDeprecatedConstructor() {
            if (this.usernameAndPassword != null) {
                throw new IllegalStateException("Username and password were specified when this builder was created, and cannot be changed.");
            }
        }

        private Supplier<UsernameAndPassword> resolveUsernameAndPasswordSupplier() {
            if (this.usernameAndPassword != null) {
                return this.usernameAndPassword;
            }
            Validators.notNull(this.username, "Must specify username");
            Validators.notNull(this.password, "Must specify password");
            if (!this.dynamicCredentials) {
                UsernameAndPassword cached = new UsernameAndPassword(this.username.get(), this.password.get());
                return () -> cached;
            }
            return () -> new UsernameAndPassword(this.username.get(), this.password.get());
        }
    }
}

