/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;

@Stability.Internal
public class BucketConfigUtil {
    private static final Duration retryDelay = Duration.ofMillis(100L);

    private BucketConfigUtil() {
    }

    @Deprecated
    public static Mono<BucketConfig> waitForBucketConfig(Core core, String bucketName, Duration timeout) {
        return BucketConfigUtil.waitForBucket(bucketName, timeout, () -> core.clusterConfig().bucketConfig(bucketName));
    }

    public static Mono<ClusterTopologyWithBucket> waitForBucketTopology(Core core, String bucketName, Duration timeout) {
        return BucketConfigUtil.waitForBucket(bucketName, timeout, () -> core.clusterConfig().bucketTopology(bucketName));
    }

    private static <T> Mono<T> waitForBucket(String bucketName, Duration timeout, Supplier<@Nullable T> topologySupplier) {
        return Mono.fromSupplier(topologySupplier).repeatWhenEmpty(attempts -> attempts.delayElements(retryDelay)).timeout(timeout).onErrorMap(TimeoutException.class, t -> new UnambiguousTimeoutException("Topology for bucket '" + RedactableArgument.redactMeta(bucketName) + "' was not available within " + timeout + " -- Does this bucket exist? Does the user have permission to access it? Consider calling bucket.waitUntilReady() first.", null));
    }
}

