/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.sort;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.queries.CoreGeoPoint;
import com.couchbase.client.core.api.search.sort.CoreSearchGeoDistanceUnits;
import com.couchbase.client.core.api.search.sort.CoreSearchSort;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.GeoDistanceSorting;
import com.couchbase.client.protostellar.search.v1.Sorting;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreSearchSortGeoDistance
extends CoreSearchSort {
    private final String field;
    private final CoreGeoPoint location;
    @Nullable
    private final CoreSearchGeoDistanceUnits unit;

    public CoreSearchSortGeoDistance(CoreGeoPoint location, String field, @Nullable CoreSearchGeoDistanceUnits unit, boolean descending) {
        super(descending);
        this.field = Validators.notNull(field, "Field");
        this.location = Validators.notNull(location, "Location");
        this.unit = unit;
    }

    @Override
    protected String identifier() {
        return "geo_distance";
    }

    @Override
    protected void injectParams(ObjectNode queryJson) {
        super.injectParams(queryJson);
        queryJson.set("location", this.location.toJson());
        queryJson.put("field", this.field);
        if (this.unit != null) {
            queryJson.put("unit", this.unit.identifier());
        }
    }

    @Override
    public Sorting asProtostellar() {
        GeoDistanceSorting.Builder builder = GeoDistanceSorting.newBuilder().setField(this.field).setDescending(this.descending).setCenter(CoreProtostellarUtil.toLatLng(this.location));
        if (this.unit != null) {
            builder.setUnit(this.unit.identifier());
        }
        return Sorting.newBuilder().setGeoDistanceSorting(builder).build();
    }
}

