/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreCounterResult;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreKvResponseMetadata;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.classic.ClassicHelper;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.msg.kv.AppendRequest;
import com.couchbase.client.core.msg.kv.DecrementRequest;
import com.couchbase.client.core.msg.kv.IncrementRequest;
import com.couchbase.client.core.msg.kv.PrependRequest;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Stability.Internal
public class BinaryAccessor {
    public static CompletableFuture<CoreMutationResult> prepend(Core core, PrependRequest request, String key, CoreKeyspace keyspace, CoreDurability durability) {
        core.send(request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new CoreMutationResult(CoreKvResponseMetadata.from(response.flexibleExtras()), keyspace, key, response.cas(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException(request, response);
        });
        return ClassicHelper.maybeWrapWithLegacyDurability(mutationResult, key, durability, core, request);
    }

    public static CompletableFuture<CoreMutationResult> append(Core core, AppendRequest request, String key, CoreKeyspace keyspace, CoreDurability durability) {
        core.send(request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new CoreMutationResult(CoreKvResponseMetadata.from(response.flexibleExtras()), keyspace, key, response.cas(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException(request, response);
        });
        return ClassicHelper.maybeWrapWithLegacyDurability(mutationResult, key, durability, core, request);
    }

    public static CompletableFuture<CoreCounterResult> decrement(Core core, DecrementRequest request, String id, CoreKeyspace keyspace, CoreDurability durability) {
        core.send(request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new CoreCounterResult(CoreKvResponseMetadata.from(response.flexibleExtras()), keyspace, id, response.cas(), response.value(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException(request, response);
        });
        return ClassicHelper.maybeWrapWithLegacyDurability(mutationResult, id, durability, core, request);
    }

    public static CompletableFuture<CoreCounterResult> increment(Core core, IncrementRequest request, String id, CoreKeyspace keyspace, CoreDurability durability) {
        core.send(request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new CoreCounterResult(CoreKvResponseMetadata.from(response.flexibleExtras()), keyspace, id, response.cas(), response.value(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException(request, response);
        });
        return ClassicHelper.maybeWrapWithLegacyDurability(mutationResult, id, durability, core, request);
    }
}

