/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.endpoint;

import com.couchbase.client.core.cnc.AbstractContext;
import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.endpoint.EndpointContext;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class UnexpectedEndpointDisconnectedEvent
extends AbstractEvent {
    private final int outstandingBeforeInactive;
    private final long connectedForNs;
    private final EndpointContext endpointContext;

    public UnexpectedEndpointDisconnectedEvent(EndpointContext context, int outstandingBeforeInactive, long connectedForNs) {
        super(Event.Severity.WARN, Event.Category.ENDPOINT, Duration.ZERO, (Context)context);
        this.outstandingBeforeInactive = outstandingBeforeInactive;
        this.connectedForNs = connectedForNs;
        this.endpointContext = context;
    }

    @Override
    public String description() {
        return "The remote side disconnected the endpoint unexpectedly";
    }

    @Override
    public Context context() {
        return new AbstractContext(){

            @Override
            public void injectExportableParams(Map<String, Object> input) {
                UnexpectedEndpointDisconnectedEvent.this.endpointContext.injectExportableParams(input);
                input.put("connectedForMs", TimeUnit.NANOSECONDS.toMillis(UnexpectedEndpointDisconnectedEvent.this.connectedForNs));
                input.put("numOutstandingRequests", UnexpectedEndpointDisconnectedEvent.this.outstandingBeforeInactive);
            }
        };
    }
}

