/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.metrics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.search.ServerSearchRequest;
import com.couchbase.client.core.topology.ClusterIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class ResponseMetricIdentifier {
    private final String serviceTracingId;
    private final String requestName;
    private final @Nullable String bucketName;
    private final @Nullable String scopeName;
    private final @Nullable String collectionName;
    private final @Nullable String exceptionSimpleName;
    private final @Nullable ClusterIdentifier clusterIdent;
    private final boolean isDefaultLoggingMeter;

    public static ResponseMetricIdentifier fromRequest(Request<?> request, @Nullable String exceptionSimpleName, @Nullable ClusterIdentifier clusterIdent, boolean isDefaultLoggingMeter) {
        ServerSearchRequest search;
        String bucketName = null;
        String scopeName = null;
        String collectionName = null;
        if (request instanceof KeyValueRequest) {
            KeyValueRequest kv = (KeyValueRequest)request;
            bucketName = request.bucket();
            scopeName = kv.collectionIdentifier().scope().orElse("_default");
            collectionName = kv.collectionIdentifier().collection().orElse("_default");
        } else if (request instanceof QueryRequest) {
            QueryRequest query = (QueryRequest)request;
            bucketName = request.bucket();
            scopeName = query.scope();
        } else if (request instanceof ServerSearchRequest && (search = (ServerSearchRequest)request).scope() != null) {
            bucketName = search.scope().bucketName();
            scopeName = search.scope().scopeName();
        }
        return new ResponseMetricIdentifier(request.serviceTracingId(), request.name(), bucketName, scopeName, collectionName, exceptionSimpleName, clusterIdent, isDefaultLoggingMeter);
    }

    public ResponseMetricIdentifier(String serviceTracingId, String requestName, @Nullable String bucketName, @Nullable String scopeName, @Nullable String collectionName, @Nullable String exceptionSimpleName, @Nullable ClusterIdentifier clusterIdent, boolean isDefaultLoggingMeter) {
        this.serviceTracingId = serviceTracingId;
        this.requestName = requestName;
        this.bucketName = bucketName;
        this.scopeName = scopeName;
        this.collectionName = collectionName;
        this.exceptionSimpleName = exceptionSimpleName;
        this.clusterIdent = clusterIdent;
        this.isDefaultLoggingMeter = isDefaultLoggingMeter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseMetricIdentifier that = (ResponseMetricIdentifier)o;
        return this.serviceTracingId.equals(that.serviceTracingId) && Objects.equals(this.requestName, that.requestName) && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.scopeName, that.scopeName) && Objects.equals(this.collectionName, that.collectionName) && Objects.equals(this.exceptionSimpleName, that.exceptionSimpleName) && Objects.equals(this.clusterIdent, that.clusterIdent);
    }

    public int hashCode() {
        return Objects.hash(this.serviceTracingId, this.requestName, this.bucketName, this.scopeName, this.collectionName, this.exceptionSimpleName, this.clusterIdent);
    }

    public Map<String, String> tags() {
        HashMap<String, String> tags = new HashMap<String, String>(9);
        tags.put("db.couchbase.service", this.serviceTracingId);
        tags.put("db.operation", this.requestName);
        if (!this.isDefaultLoggingMeter) {
            tags.put("db.name", this.bucketName);
            tags.put("db.couchbase.scope", this.scopeName);
            tags.put("db.couchbase.collection", this.collectionName);
            tags.put("db.couchbase.cluster_uuid", this.clusterIdent == null ? null : this.clusterIdent.clusterUuid());
            tags.put("db.couchbase.cluster_name", this.clusterIdent == null ? null : this.clusterIdent.clusterName());
            if (this.exceptionSimpleName != null) {
                tags.put("outcome", this.exceptionSimpleName);
            } else {
                tags.put("outcome", "Success");
            }
        }
        return tags;
    }
}

